/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import com.flowpowered.math.vector.Vector2i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class Grid {
    public static final Grid UNIT = new Grid(Vector2i.ONE);
    private final Vector2i gridSize;
    private final Vector2i offset;

    public Grid(int gridSize) {
        this(gridSize, 0);
    }

    public Grid(int gridSize, int offset) {
        this(new Vector2i(gridSize, gridSize), new Vector2i(offset, offset));
    }

    public Grid(Vector2i gridSize) {
        this(gridSize, Vector2i.ZERO);
    }

    public Grid(Vector2i gridSize, Vector2i offset) {
        Objects.requireNonNull(gridSize);
        Objects.requireNonNull(offset);
        this.gridSize = gridSize = gridSize.max(1, 1);
        this.offset = offset;
    }

    public Vector2i getGridSize() {
        return this.gridSize;
    }

    public Vector2i getOffset() {
        return this.offset;
    }

    public int getCellX(int posX) {
        return Math.floorDiv(posX - this.offset.getX(), this.gridSize.getX());
    }

    public int getCellY(int posY) {
        return Math.floorDiv(posY - this.offset.getY(), this.gridSize.getY());
    }

    public Vector2i getCell(Vector2i pos) {
        return new Vector2i(this.getCellX(pos.getX()), this.getCellY(pos.getY()));
    }

    public int getLocalX(int posX) {
        return Math.floorMod(posX - this.offset.getX(), this.gridSize.getX());
    }

    public int getLocalY(int posY) {
        return Math.floorMod(posY - this.offset.getY(), this.gridSize.getY());
    }

    public Vector2i getLocal(Vector2i pos) {
        return new Vector2i(this.getLocalX(pos.getX()), this.getLocalY(pos.getY()));
    }

    public int getCellMinX(int cellX) {
        return cellX * this.gridSize.getX() + this.offset.getX();
    }

    public int getCellMinY(int cellY) {
        return cellY * this.gridSize.getY() + this.offset.getY();
    }

    public Vector2i getCellMin(Vector2i cell) {
        return new Vector2i(this.getCellMinX(cell.getX()), this.getCellMinY(cell.getY()));
    }

    public int getCellMaxX(int cellX) {
        return (cellX + 1) * this.gridSize.getX() + this.offset.getX() - 1;
    }

    public int getCellMaxY(int cellY) {
        return (cellY + 1) * this.gridSize.getY() + this.offset.getY() - 1;
    }

    public Vector2i getCellMax(Vector2i cell) {
        return new Vector2i(this.getCellMaxX(cell.getX()), this.getCellMaxY(cell.getY()));
    }

    public int getCellMinX(int cellX, Grid targetGrid) {
        return targetGrid.getCellX(this.getCellMinX(cellX));
    }

    public int getCellMinY(int cellY, Grid targetGrid) {
        return targetGrid.getCellY(this.getCellMinY(cellY));
    }

    public Vector2i getCellMin(Vector2i cell, Grid targetGrid) {
        return new Vector2i(this.getCellMinX(cell.getX(), targetGrid), this.getCellMinY(cell.getY(), targetGrid));
    }

    public int getCellMaxX(int cellX, Grid targetGrid) {
        return targetGrid.getCellX(this.getCellMaxX(cellX));
    }

    public int getCellMaxY(int cellY, Grid targetGrid) {
        return targetGrid.getCellY(this.getCellMaxY(cellY));
    }

    public Vector2i getCellMax(Vector2i cell, Grid targetGrid) {
        return new Vector2i(this.getCellMaxX(cell.getX(), targetGrid), this.getCellMaxY(cell.getY(), targetGrid));
    }

    public Collection<Vector2i> getIntersecting(Vector2i cell, Grid targetGrid) {
        Vector2i max;
        Vector2i min2 = this.getCellMin(cell, targetGrid);
        if (min2.equals(max = this.getCellMax(cell, targetGrid))) {
            return Collections.singleton(min2);
        }
        ArrayList<Vector2i> intersects = new ArrayList<Vector2i>();
        for (int x = min2.getX(); x <= max.getX(); ++x) {
            for (int y = min2.getY(); y <= max.getY(); ++y) {
                intersects.add(new Vector2i(x, y));
            }
        }
        return intersects;
    }

    public Grid multiply(Grid other) {
        return new Grid(this.gridSize.mul(other.gridSize), this.offset.mul(other.gridSize).add(other.offset));
    }

    public Grid divide(Grid other) {
        return new Grid(this.gridSize.div(other.gridSize), this.offset.sub(other.offset).div(other.gridSize));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grid grid = (Grid)o;
        return this.gridSize.equals(grid.gridSize) && this.offset.equals(grid.offset);
    }

    public int hashCode() {
        return Objects.hash(this.gridSize, this.offset);
    }

    public String toString() {
        return "Grid{gridSize=" + String.valueOf(this.gridSize) + ", offset=" + String.valueOf(this.offset) + "}";
    }
}

