/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class VectorM3f {
    public float x;
    public float y;
    public float z;

    public VectorM3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VectorM3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public VectorM3f transform(MatrixM3f t) {
        return this.set(t.m00 * this.x + t.m01 * this.y + t.m02 * this.z, t.m10 * this.x + t.m11 * this.y + t.m12 * this.z, t.m20 * this.x + t.m21 * this.y + t.m22 * this.z);
    }

    public VectorM3f transform(MatrixM4f t) {
        return this.set(t.m00 * this.x + t.m01 * this.y + t.m02 * this.z + t.m03, t.m10 * this.x + t.m11 * this.y + t.m12 * this.z + t.m13, t.m20 * this.x + t.m21 * this.y + t.m22 * this.z + t.m23);
    }

    public VectorM3f rotateAndScale(MatrixM4f t) {
        return this.set(t.m00 * this.x + t.m01 * this.y + t.m02 * this.z, t.m10 * this.x + t.m11 * this.y + t.m12 * this.z, t.m20 * this.x + t.m21 * this.y + t.m22 * this.z);
    }

    public VectorM3f normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }
}

