/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.threejs;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;

public class BufferAttribute {
    private int itemSize;
    private boolean normalized;
    private float[] values;

    public BufferAttribute(float[] values, int itemSize) {
        Preconditions.checkArgument(values.length % itemSize == 0, "The length of the values-array is not a multiple of the item-size!");
        this.values = values;
        this.itemSize = itemSize;
        this.normalized = false;
    }

    public BufferAttribute(float[] values, int itemSize, boolean normalized) {
        Preconditions.checkArgument(values.length % itemSize == 0, "The length of the values-array is not a multiple of the item-size!");
        this.values = values;
        this.itemSize = itemSize;
        this.normalized = normalized;
    }

    public void writeJson(JsonWriter json) throws IOException {
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value((long)this.itemSize);
        json.name("normalized").value(this.normalized);
        json.name("array").beginArray();
        for (int i = 0; i < this.values.length; ++i) {
            double d = (double)Math.round((double)this.values[i] * 10000.0) / 10000.0;
            if (d == (double)((long)d)) {
                json.value((long)d);
                continue;
            }
            json.value(d);
        }
        json.endArray();
        json.endObject();
    }

    public int getItemSize() {
        return this.itemSize;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public int getValueCount() {
        return this.values.length;
    }

    public int getItemCount() {
        return Math.floorDiv(this.getValueCount(), this.getItemSize());
    }

    public float[] values() {
        return this.values;
    }

    public static BufferAttribute readJson(JsonReader json) throws IOException {
        ArrayList<Float> list = new ArrayList<Float>(1000);
        int itemSize = 1;
        boolean normalized = false;
        json.beginObject();
        while (json.hasNext()) {
            String name = json.nextName();
            if (name.equals("array")) {
                json.beginArray();
                while (json.hasNext()) {
                    list.add(Float.valueOf((float)json.nextDouble()));
                }
                json.endArray();
                continue;
            }
            if (name.equals("itemSize")) {
                itemSize = json.nextInt();
                continue;
            }
            if (name.equals("normalized")) {
                normalized = json.nextBoolean();
                continue;
            }
            json.skipValue();
        }
        json.endObject();
        float[] values = new float[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ((Float)list.get(i)).floatValue();
        }
        return new BufferAttribute(values, itemSize, normalized);
    }
}

