/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql.dialect;

import de.bluecolored.bluemap.core.storage.sql.MySQLStorage;
import de.bluecolored.bluemap.core.storage.sql.PostgreSQLStorage;
import de.bluecolored.bluemap.core.storage.sql.SQLStorage;
import de.bluecolored.bluemap.core.storage.sql.SQLStorageSettings;
import de.bluecolored.bluemap.core.storage.sql.SQLiteStorage;

public enum DialectType {
    MYSQL(MySQLStorage::new, "mysql"),
    MARIADB(MySQLStorage::new, "mariadb"),
    POSTGRESQL(PostgreSQLStorage::new, "postgresql"),
    SQLITE(SQLiteStorage::new, "sqlite");

    private static final DialectType FALLBACK;
    private final SQLStorageFactory storageFactory;
    private final String dialectName;

    private DialectType(SQLStorageFactory storageFactory, String dialectName) {
        this.storageFactory = storageFactory;
        this.dialectName = dialectName;
    }

    public String getDialectName() {
        return this.dialectName;
    }

    public static SQLStorage getStorage(String dialectName, SQLStorageSettings settings) throws Exception {
        for (DialectType dialect : DialectType.values()) {
            if (!dialect.getDialectName().equals(dialectName)) continue;
            return dialect.storageFactory.provide(settings);
        }
        return DialectType.FALLBACK.storageFactory.provide(settings);
    }

    static {
        FALLBACK = MYSQL;
    }

    @FunctionalInterface
    public static interface SQLStorageFactory {
        public SQLStorage provide(SQLStorageSettings var1) throws Exception;
    }
}

