/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.file;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.storage.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.Compression;
import de.bluecolored.bluemap.core.storage.MetaInfo;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.TileInfo;
import de.bluecolored.bluemap.core.storage.file.FileStorageSettings;
import de.bluecolored.bluemap.core.util.DeletingPathVisitor;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DebugDump
public class FileStorage
extends Storage {
    private final Path root;
    private final Compression hiresCompression;

    public FileStorage(FileStorageSettings config) {
        this.root = config.getRoot();
        this.hiresCompression = config.getCompression();
    }

    public FileStorage(Path root, Compression compression) {
        this.root = root;
        this.hiresCompression = compression;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public OutputStream writeMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        Path file = this.getFilePath(mapId, lod, tile);
        OutputStream os = FileHelper.createFilepartOutputStream(file);
        os = new BufferedOutputStream(os);
        try {
            os = compression.compress(os);
        }
        catch (IOException ex) {
            os.close();
            throw ex;
        }
        return os;
    }

    @Override
    public Optional<CompressedInputStream> readMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        Path file = this.getFilePath(mapId, lod, tile);
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        InputStream is = Files.newInputStream(file, StandardOpenOption.READ);
        is = new BufferedInputStream(is);
        return Optional.of(new CompressedInputStream(is, compression));
    }

    @Override
    public Optional<TileInfo> readMapTileInfo(final String mapId, final int lod, final Vector2i tile) throws IOException {
        final Compression compression = lod == 0 ? this.hiresCompression : Compression.NONE;
        Path file = this.getFilePath(mapId, lod, tile);
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        final long size = Files.size(file);
        final long lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        return Optional.of(new TileInfo(){

            @Override
            public CompressedInputStream readMapTile() throws IOException {
                return FileStorage.this.readMapTile(mapId, lod, tile).orElseThrow(() -> new IOException("Tile no longer present!"));
            }

            @Override
            public Compression getCompression() {
                return compression;
            }

            @Override
            public long getSize() {
                return size;
            }

            @Override
            public long getLastModified() {
                return lastModified;
            }
        });
    }

    @Override
    public void deleteMapTile(String mapId, int lod, Vector2i tile) throws IOException {
        Path file = this.getFilePath(mapId, lod, tile);
        Files.deleteIfExists(file);
    }

    @Override
    public OutputStream writeMeta(String mapId, String name) throws IOException {
        Path file = this.getMetaFilePath(mapId, name);
        OutputStream os = FileHelper.createFilepartOutputStream(file);
        os = new BufferedOutputStream(os);
        return os;
    }

    @Override
    public Optional<InputStream> readMeta(String mapId, String name) throws IOException {
        Path file = this.getMetaFilePath(mapId, name);
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        InputStream is = Files.newInputStream(file, StandardOpenOption.READ);
        is = new BufferedInputStream(is);
        return Optional.of(is);
    }

    @Override
    public Optional<MetaInfo> readMetaInfo(final String mapId, final String name) throws IOException {
        Path file = this.getMetaFilePath(mapId, name);
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        final long size = Files.size(file);
        return Optional.of(new MetaInfo(){

            @Override
            public InputStream readMeta() throws IOException {
                return FileStorage.this.readMeta(mapId, name).orElseThrow(() -> new IOException("Meta no longer present!"));
            }

            @Override
            public long getSize() {
                return size;
            }
        });
    }

    @Override
    public void deleteMeta(String mapId, String name) throws IOException {
        Path file = this.getMetaFilePath(mapId, name);
        Files.deleteIfExists(file);
    }

    @Override
    public void purgeMap(String mapId, Function<Storage.ProgressInfo, Boolean> onProgress) throws IOException {
        LinkedList subFiles;
        Path directory = this.getFilePath(mapId);
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> pathStream = Files.walk(directory, 3, new FileVisitOption[0]);){
            subFiles = pathStream.collect(Collectors.toCollection(LinkedList::new));
        }
        int subFilesCount = subFiles.size();
        while (!subFiles.isEmpty()) {
            Path subFile = (Path)subFiles.getLast();
            Files.walkFileTree(subFile, DeletingPathVisitor.INSTANCE);
            subFiles.removeLast();
            if (onProgress.apply(new Storage.ProgressInfo(1.0 - (double)subFiles.size() / (double)subFilesCount)).booleanValue()) continue;
            return;
        }
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, DeletingPathVisitor.INSTANCE);
        }
    }

    @Override
    public Collection<String> collectMapIds() throws IOException {
        try (Stream<Path> fileStream = Files.list(this.root);){
            Collection collection = fileStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toList());
            return collection;
        }
    }

    public Path getFilePath(String mapId, int lod, Vector2i tile) {
        String path = "x" + tile.getX() + "z" + tile.getY();
        char[] cs = path.toCharArray();
        ArrayList<String> folders = new ArrayList<String>();
        StringBuilder folder = new StringBuilder();
        for (char c : cs) {
            folder.append(c);
            if (c < '0' || c > '9') continue;
            folders.add(folder.toString());
            folder.delete(0, folder.length());
        }
        String fileName = (String)folders.remove(folders.size() - 1);
        Path p = this.getFilePath(mapId).resolve("tiles").resolve(Integer.toString(lod));
        for (String s2 : folders) {
            p = p.resolve(s2);
        }
        if (lod == 0) {
            return p.resolve(fileName + ".json" + this.hiresCompression.getFileSuffix());
        }
        return p.resolve(fileName + ".png");
    }

    public Path getFilePath(String mapId) {
        return this.root.resolve(mapId);
    }

    public Path getMetaFilePath(String mapId, String name) {
        return this.getFilePath(mapId).resolve(FileStorage.escapeMetaName(name).replace("/", this.root.getFileSystem().getSeparator()));
    }
}

