/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.storage.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.MetaInfo;
import de.bluecolored.bluemap.core.storage.TileInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public abstract class Storage
implements Closeable {
    public abstract void initialize() throws IOException;

    public abstract OutputStream writeMapTile(String var1, int var2, Vector2i var3) throws IOException;

    public abstract Optional<CompressedInputStream> readMapTile(String var1, int var2, Vector2i var3) throws IOException;

    public abstract Optional<TileInfo> readMapTileInfo(String var1, int var2, Vector2i var3) throws IOException;

    public abstract void deleteMapTile(String var1, int var2, Vector2i var3) throws IOException;

    public abstract OutputStream writeMeta(String var1, String var2) throws IOException;

    public abstract Optional<InputStream> readMeta(String var1, String var2) throws IOException;

    public abstract Optional<MetaInfo> readMetaInfo(String var1, String var2) throws IOException;

    public abstract void deleteMeta(String var1, String var2) throws IOException;

    public abstract void purgeMap(String var1, Function<ProgressInfo, Boolean> var2) throws IOException;

    public abstract Collection<String> collectMapIds() throws IOException;

    public MapStorage mapStorage(String mapId) {
        return new MapStorage(mapId);
    }

    public TileStorage tileStorage(String mapId, int lod) {
        return new TileStorage(mapId, lod);
    }

    public abstract boolean isClosed();

    public static String escapeMetaName(String name) {
        return name.replaceAll("[^\\w\\d.\\-_/]", "_").replace("..", "_.");
    }

    public class MapStorage {
        private final String mapId;

        private MapStorage(String mapId) {
            this.mapId = mapId;
        }

        public OutputStream write(int lod, Vector2i tile) throws IOException {
            return Storage.this.writeMapTile(this.mapId, lod, tile);
        }

        public Optional<CompressedInputStream> read(int lod, Vector2i tile) throws IOException {
            return Storage.this.readMapTile(this.mapId, lod, tile);
        }

        public void delete(int lod, Vector2i tile) throws IOException {
            Storage.this.deleteMapTile(this.mapId, lod, tile);
        }

        public Storage getStorage() {
            return Storage.this;
        }
    }

    public class TileStorage {
        private final String mapId;
        private final int lod;

        private TileStorage(String mapId, int lod) {
            this.mapId = mapId;
            this.lod = lod;
        }

        public OutputStream write(Vector2i tile) throws IOException {
            return Storage.this.writeMapTile(this.mapId, this.lod, tile);
        }

        public Optional<CompressedInputStream> read(Vector2i tile) throws IOException {
            return Storage.this.readMapTile(this.mapId, this.lod, tile);
        }

        public void delete(Vector2i tile) throws IOException {
            Storage.this.deleteMapTile(this.mapId, this.lod, tile);
        }

        public Storage getStorage() {
            return Storage.this;
        }
    }

    public static class ProgressInfo {
        private final double progress;

        public ProgressInfo(double progress) {
            this.progress = progress;
        }

        public double getProgress() {
            return this.progress;
        }
    }
}

