/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage;

import de.bluecolored.bluemap.core.storage.Compression;
import java.io.IOException;
import java.io.InputStream;

public class CompressedInputStream
extends InputStream {
    private final InputStream in;
    private final Compression compression;

    public CompressedInputStream(InputStream in, Compression compression) {
        this.in = in;
        this.compression = compression;
    }

    public InputStream decompress() throws IOException {
        return this.compression.decompress(this.in);
    }

    public Compression getCompression() {
        return this.compression;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }
}

