/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.resourcepack.texture;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.util.BufferedImageUtil;
import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

@DebugDump
public class Texture {
    public static final Texture MISSING = new Texture(new ResourcePath<Texture>("bluemap", "missing"), new Color().set(0.5f, 0.0f, 0.5f, 1.0f, false), false, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAPklEQVR4Xu3MsQkAMAwDQe2/tFPnBB4gpLhG8MpkZpNkZ6AKZKAKZKAKZKAKZKAKZKAKZKAKWg0XD/UPnjg4MbX+EDdeTUwAAAAASUVORK5CYII=");
    private ResourcePath<Texture> resourcePath;
    private Color color;
    private boolean halfTransparent;
    private String texture;
    private transient Color colorPremultiplied;

    private Texture() {
    }

    private Texture(ResourcePath<Texture> resourcePath, Color color, boolean halfTransparent, String texture) {
        this.resourcePath = resourcePath;
        this.color = color.straight();
        this.halfTransparent = halfTransparent;
        this.texture = texture;
    }

    private Texture(ResourcePath<Texture> resourcePath) {
        this.resourcePath = resourcePath;
        this.color = Texture.MISSING.color;
        this.halfTransparent = Texture.MISSING.halfTransparent;
        this.texture = Texture.MISSING.texture;
    }

    public ResourcePath<Texture> getResourcePath() {
        return this.resourcePath;
    }

    public Color getColorStraight() {
        return this.color;
    }

    public boolean isHalfTransparent() {
        return this.halfTransparent;
    }

    public Color getColorPremultiplied() {
        if (this.colorPremultiplied == null && this.color != null) {
            this.colorPremultiplied = new Color().set(this.color).premultiplied();
        }
        return this.colorPremultiplied;
    }

    public String getTexture() {
        return this.texture;
    }

    public void unloadImageData() {
        this.texture = null;
    }

    public static Texture from(ResourcePath<Texture> resourcePath, BufferedImage image) throws IOException {
        return Texture.from(resourcePath, image, true);
    }

    public static Texture from(ResourcePath<Texture> resourcePath, BufferedImage image, boolean animated) throws IOException {
        if (animated && image.getHeight() > image.getWidth()) {
            image = image.getSubimage(0, 0, image.getWidth(), image.getWidth());
        }
        boolean halfTransparent = Texture.checkHalfTransparent(image);
        Color color = BufferedImageUtil.averageColor(image);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        String base64 = "data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray());
        return new Texture(resourcePath, color, halfTransparent, base64);
    }

    private static boolean checkHalfTransparent(BufferedImage image) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha <= 0 || alpha >= 255) continue;
                return true;
            }
        }
        return false;
    }

    public static Texture missing(ResourcePath<Texture> resourcePath) {
        return new Texture(resourcePath);
    }
}

