/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.resourcepack.blockstate;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.util.Preconditions;
import de.bluecolored.bluemap.core.world.BlockState;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@FunctionalInterface
public interface BlockStateCondition {
    public static final BlockStateCondition MATCH_ALL = new All();
    public static final BlockStateCondition MATCH_NONE = new None();

    public boolean matches(BlockState var1);

    public static BlockStateCondition all() {
        return MATCH_ALL;
    }

    public static BlockStateCondition none() {
        return MATCH_NONE;
    }

    public static BlockStateCondition and(BlockStateCondition ... conditions) {
        Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
        if (conditions.length == 1) {
            return conditions[0];
        }
        return new And(conditions);
    }

    public static BlockStateCondition or(BlockStateCondition ... conditions) {
        Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
        if (conditions.length == 1) {
            return conditions[0];
        }
        return new Or(conditions);
    }

    public static BlockStateCondition property(String key, String value) {
        return new Property(key, value);
    }

    public static BlockStateCondition property(String key, String ... possibleValues) {
        Preconditions.checkArgument(possibleValues.length > 0, "Must be at least one value!");
        if (possibleValues.length == 1) {
            return BlockStateCondition.property(key, possibleValues[0]);
        }
        return new PropertySet(key, possibleValues);
    }

    @DebugDump
    public static class And
    implements BlockStateCondition {
        final BlockStateCondition[] conditions;
        final int distinctProperties;

        private And(BlockStateCondition ... conditions) {
            Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
            this.conditions = conditions;
            HashSet<String> distinctPropertiesSet = new HashSet<String>();
            for (BlockStateCondition condition : this.conditions) {
                if (!(condition instanceof Property)) continue;
                distinctPropertiesSet.add(((Property)condition).key);
            }
            this.distinctProperties = distinctPropertiesSet.size();
        }

        @Override
        public boolean matches(BlockState state) {
            if (state.getProperties().size() < this.distinctProperties) {
                return false;
            }
            for (BlockStateCondition condition : this.conditions) {
                if (condition.matches(state)) continue;
                return false;
            }
            return true;
        }
    }

    @DebugDump
    public static class Or
    implements BlockStateCondition {
        private final BlockStateCondition[] conditions;

        private Or(BlockStateCondition ... conditions) {
            Preconditions.checkArgument(conditions.length > 0, "Must be at least one condition!");
            this.conditions = conditions;
        }

        @Override
        public boolean matches(BlockState state) {
            for (BlockStateCondition condition : this.conditions) {
                if (!condition.matches(state)) continue;
                return true;
            }
            return false;
        }
    }

    @DebugDump
    public static class Property
    implements BlockStateCondition {
        private final String key;
        private final String value;

        private Property(String key, String value) {
            this.key = key.toLowerCase(Locale.ROOT);
            this.value = value.toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean matches(BlockState state) {
            String value = state.getProperties().get(this.key);
            if (value == null) {
                return false;
            }
            return value.equals(this.value);
        }
    }

    @DebugDump
    public static class PropertySet
    implements BlockStateCondition {
        private final String key;
        private final Set<String> possibleValues;

        private PropertySet(String key, String ... possibleValues) {
            this.key = key.toLowerCase(Locale.ROOT);
            this.possibleValues = new HashSet<String>();
            for (String value : possibleValues) {
                this.possibleValues.add(value.toLowerCase(Locale.ROOT));
            }
        }

        @Override
        public boolean matches(BlockState state) {
            String value = state.getProperties().get(this.key);
            if (value == null) {
                return false;
            }
            return this.possibleValues.contains(value);
        }
    }

    public static class All
    implements BlockStateCondition {
        @Override
        public boolean matches(BlockState state) {
            return true;
        }
    }

    public static class None
    implements BlockStateCondition {
        @Override
        public boolean matches(BlockState state) {
            return false;
        }
    }
}

