/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.resourcepack.blockmodel;

import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.resourcepack.blockmodel.TextureVariable;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.function.Function;

@DebugDump
public class Face {
    private static final TextureVariable DEFAULT_TEXTURE = new TextureVariable(ResourcePack.MISSING_TEXTURE);
    private Vector4f uv;
    private TextureVariable texture = DEFAULT_TEXTURE;
    private Direction cullface;
    private int rotation = 0;
    private int tintindex = -1;

    private Face() {
    }

    private Face(Face copyFrom) {
        this.uv = copyFrom.uv;
        this.texture = copyFrom.texture.copy();
        this.cullface = copyFrom.cullface;
        this.rotation = copyFrom.rotation;
        this.tintindex = copyFrom.tintindex;
    }

    void init(Direction direction, Function<Direction, Vector4f> defaultUvCalculator, Function<Direction, Direction> defaultCullfaceCalculator) {
        if (this.cullface == null) {
            this.cullface = defaultCullfaceCalculator.apply(direction);
        }
        if (this.uv == null) {
            this.uv = defaultUvCalculator.apply(direction);
        }
    }

    public Vector4f getUv() {
        return this.uv;
    }

    public TextureVariable getTexture() {
        return this.texture;
    }

    public Direction getCullface() {
        return this.cullface;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getTintindex() {
        return this.tintindex;
    }

    public Face copy() {
        return new Face(this);
    }

    public void optimize(ResourcePack resourcePack) {
        this.texture.optimize(resourcePack);
    }
}

