/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.biome;

import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.biome.BiomeConfigEntry;
import de.bluecolored.bluemap.core.resources.biome.datapack.DpBiome;
import de.bluecolored.bluemap.core.world.Biome;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

@DebugDump
public class BiomeConfig {
    private final Map<String, Biome> biomes = new HashMap<String, Biome>();

    public void load(Path configFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            JsonReader json = new JsonReader((Reader)reader);
            json.setLenient(true);
            json.beginObject();
            while (json.hasNext()) {
                String formatted = json.nextName();
                BiomeConfigEntry entry = (BiomeConfigEntry)ResourcesGson.INSTANCE.fromJson(json, BiomeConfigEntry.class);
                Biome biome = entry.createBiome(formatted);
                this.biomes.putIfAbsent(biome.getFormatted(), biome);
            }
            json.endObject();
        }
    }

    public void loadDatapackBiome(String namespace, Path biomeFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(biomeFile);){
            JsonReader json = new JsonReader((Reader)reader);
            json.setLenient(true);
            DpBiome dpBiome = (DpBiome)ResourcesGson.INSTANCE.fromJson(json, DpBiome.class);
            Object formatted = namespace + ":" + biomeFile.getFileName().toString();
            int fileEndingDot = ((String)formatted).lastIndexOf(46);
            if (fileEndingDot != -1) {
                formatted = ((String)formatted).substring(0, fileEndingDot);
            }
            Biome biome = dpBiome.createBiome((String)formatted);
            this.biomes.putIfAbsent(biome.getFormatted(), biome);
        }
    }

    public Biome getBiome(String formatted) {
        return this.biomes.getOrDefault(formatted, Biome.DEFAULT);
    }
}

