/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@DebugDump
@JsonAdapter(value=Adapter.class)
public class ResourcePath<T>
extends Key {
    private T resource = null;

    public ResourcePath(String formatted) {
        super(formatted.toLowerCase(Locale.ROOT));
    }

    public ResourcePath(String namespace, String value) {
        super(namespace.toLowerCase(Locale.ROOT), value.toLowerCase(Locale.ROOT));
    }

    public ResourcePath(Path filePath) {
        super(ResourcePath.parsePath(filePath).toLowerCase(Locale.ROOT));
    }

    @Nullable
    public T getResource() {
        return this.resource;
    }

    @Nullable
    public T getResource(Function<ResourcePath<T>, T> supplier) {
        if (this.resource == null) {
            this.resource = supplier.apply(this);
        }
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    private static String parsePath(Path filePath) {
        if (filePath.getNameCount() < 4) {
            throw new IllegalArgumentException("The provided filePath has less than 4 segments!");
        }
        if (!filePath.getName(0).toString().equalsIgnoreCase("assets")) {
            throw new IllegalArgumentException("The provided filePath doesn't start with 'assets'!");
        }
        String namespace = filePath.getName(1).toString();
        String path = filePath.subpath(3, filePath.getNameCount()).toString().replace(filePath.getFileSystem().getSeparator(), "/");
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex != -1) {
            path = path.substring(0, dotIndex);
        }
        return namespace + ":" + path;
    }

    static class Adapter
    implements TypeAdapterFactory {
        Adapter() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!type.getRawType().isAssignableFrom(ResourcePath.class)) {
                return null;
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    out.value(((ResourcePath)value).getFormatted());
                }

                public T read(JsonReader in) throws IOException {
                    return new ResourcePath(in.nextString());
                }
            };
        }
    }
}

