/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.mca.region;

import de.bluecolored.bluemap.core.mca.MCAWorld;
import de.bluecolored.bluemap.core.mca.region.LinearRegion;
import de.bluecolored.bluemap.core.mca.region.MCARegion;
import de.bluecolored.bluemap.core.world.Region;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RegionType {
    MCA(MCARegion::new, ".mca", MCARegion::getRegionFileName),
    LINEAR(LinearRegion::new, ".linear", LinearRegion::getRegionFileName);

    private static final RegionType[] VALUES;
    private static final RegionType DEFAULT;
    private final String fileSuffix;
    private final RegionFactory regionFactory;
    private final RegionFileNameFunction regionFileNameFunction;

    private RegionType(RegionFactory regionFactory, String fileSuffix, RegionFileNameFunction regionFileNameFunction) {
        this.fileSuffix = fileSuffix;
        this.regionFactory = regionFactory;
        this.regionFileNameFunction = regionFileNameFunction;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public Region createRegion(MCAWorld world, Path regionFile) {
        return this.regionFactory.create(world, regionFile);
    }

    public String getRegionFileName(int regionX, int regionZ) {
        return this.regionFileNameFunction.getRegionFileName(regionX, regionZ);
    }

    public Path getRegionFile(Path regionFolder, int regionX, int regionZ) {
        return regionFolder.resolve(this.getRegionFileName(regionX, regionZ));
    }

    @Nullable
    public static RegionType forFileName(String fileName) {
        for (int i = 0; i < VALUES.length; ++i) {
            RegionType regionType = VALUES[i];
            if (!fileName.endsWith(regionType.fileSuffix)) continue;
            return regionType;
        }
        return null;
    }

    @NotNull
    public static Region loadRegion(MCAWorld world, Path regionFolder, int regionX, int regionZ) {
        for (int i = 0; i < VALUES.length; ++i) {
            RegionType regionType = VALUES[i];
            Path regionFile = regionType.getRegionFile(regionFolder, regionX, regionZ);
            if (!Files.exists(regionFile, new LinkOption[0])) continue;
            return regionType.createRegion(world, regionFile);
        }
        return DEFAULT.createRegion(world, DEFAULT.getRegionFile(regionFolder, regionX, regionZ));
    }

    static {
        VALUES = RegionType.values();
        DEFAULT = MCA;
    }

    @FunctionalInterface
    static interface RegionFactory {
        public Region create(MCAWorld var1, Path var2);
    }

    @FunctionalInterface
    static interface RegionFileNameFunction {
        public String getRegionFileName(int var1, int var2);
    }
}

