/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.lowres;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.lowres.LowresTile;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.util.Vector2iCache;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.shadow.benmanes.caffeine.cache.CacheWriter;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.shadow.benmanes.caffeine.cache.RemovalCause;
import de.bluecolored.shadow.benmanes.caffeine.cache.Scheduler;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class LowresLayer {
    private static final Vector2iCache VECTOR_2_I_CACHE = new Vector2iCache();
    private final Storage.MapStorage mapStorage;
    private final Grid tileGrid;
    private final int lodFactor;
    private final int lod;
    private final LoadingCache<Vector2i, LowresTile> tileCache;
    @Nullable
    private final LowresLayer nextLayer;

    public LowresLayer(Storage.MapStorage mapStorage, Grid tileGrid, int lodCount, int lodFactor, int lod, @Nullable LowresLayer nextLayer) {
        this.mapStorage = mapStorage;
        this.tileGrid = tileGrid;
        this.lodFactor = lodFactor;
        this.lod = lod;
        this.nextLayer = nextLayer;
        LoadingCache<Vector2i, LowresTile> tileWeakInstanceCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakValues().build(this::createTile);
        this.tileCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).scheduler(Scheduler.systemScheduler()).expireAfterAccess(10L, TimeUnit.SECONDS).expireAfterWrite(5L, TimeUnit.MINUTES).writer(new CacheWriter<Vector2i, LowresTile>(){

            @Override
            public void write(@NonNull Vector2i key, @NonNull LowresTile value) {
            }

            @Override
            public void delete(@NonNull Vector2i key, @Nullable LowresTile value, @NonNull RemovalCause cause) {
                LowresLayer.this.saveTile(key, value, cause);
            }
        }).build(tileWeakInstanceCache::get);
    }

    public void save() {
        this.tileCache.invalidateAll();
        this.tileCache.cleanUp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LowresTile createTile(Vector2i tilePos) {
        try (InputStream in = this.mapStorage.read(this.lod, tilePos).orElse(null);){
            if (in == null) return new LowresTile(this.tileGrid.getGridSize());
            LowresTile lowresTile = new LowresTile(this.tileGrid.getGridSize(), in);
            return lowresTile;
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ")", e);
        }
        return new LowresTile(this.tileGrid.getGridSize());
    }

    private void saveTile(Vector2i tilePos, @Nullable LowresTile tile, RemovalCause removalCause) {
        if (tile == null) {
            return;
        }
        if (this.mapStorage.getStorage().isClosed()) {
            Logger.global.logDebug("Tried to save tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ") but storage is already closed.");
            return;
        }
        try (OutputStream out = this.mapStorage.write(this.lod, tilePos);){
            tile.save(out);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ")", e);
        }
        if (this.nextLayer == null) {
            return;
        }
        Color averageColor = new Color();
        Color color = new Color();
        int nextLodTileX = Math.floorDiv(tilePos.getX(), this.lodFactor);
        int nextLodTileY = Math.floorDiv(tilePos.getY(), this.lodFactor);
        Vector2i groupCount = new Vector2i(Math.floorDiv(this.tileGrid.getGridSize().getX(), this.lodFactor), Math.floorDiv(this.tileGrid.getGridSize().getY(), this.lodFactor));
        for (int gX = 0; gX < groupCount.getX(); ++gX) {
            for (int gY = 0; gY < groupCount.getY(); ++gY) {
                averageColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                int averageHeight = 0;
                int averageBlockLight = 0;
                int count = 0;
                for (int x = 0; x < this.lodFactor; ++x) {
                    for (int y = 0; y < this.lodFactor; ++y) {
                        ++count;
                        averageColor.add(tile.getColor(gX * this.lodFactor + x, gY * this.lodFactor + y, color).premultiplied());
                        averageHeight += tile.getHeight(gX * this.lodFactor + x, gY * this.lodFactor + y);
                        averageBlockLight += tile.getBlockLight(gX * this.lodFactor + x, gY * this.lodFactor + y);
                    }
                }
                averageColor.div(count);
                this.nextLayer.set(nextLodTileX, nextLodTileY, Math.floorMod(tilePos.getX(), this.lodFactor) * groupCount.getX() + gX, Math.floorMod(tilePos.getY(), this.lodFactor) * groupCount.getY() + gY, averageColor, averageHeight /= count, averageBlockLight /= count);
            }
        }
    }

    private LowresTile getTile(int x, int z) {
        return this.tileCache.get(VECTOR_2_I_CACHE.get(x, z));
    }

    void set(int cellX, int cellZ, int pixelX, int pixelZ, Color color, int height, int blockLight) {
        this.getTile(cellX, cellZ).set(pixelX, pixelZ, color, height, blockLight);
        if (pixelX == 0) {
            this.getTile(cellX - 1, cellZ).set(this.tileGrid.getGridSize().getX(), pixelZ, color, height, blockLight);
        }
        if (pixelZ == 0) {
            this.getTile(cellX, cellZ - 1).set(pixelX, this.tileGrid.getGridSize().getY(), color, height, blockLight);
        }
        if (pixelX == 0 && pixelZ == 0) {
            this.getTile(cellX - 1, cellZ - 1).set(this.tileGrid.getGridSize().getX(), this.tileGrid.getGridSize().getY(), color, height, blockLight);
        }
    }
}

