/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector3i;

public interface RenderSettings {
    public static final Vector3i DEFAULT_MIN = Vector3i.from(Integer.MIN_VALUE);
    public static final Vector3i DEFAULT_MAX = Vector3i.from(Integer.MAX_VALUE);

    public int getRemoveCavesBelowY();

    public int getCaveDetectionOceanFloor();

    public boolean isCaveDetectionUsesBlockLight();

    default public Vector3i getMinPos() {
        return DEFAULT_MIN;
    }

    default public Vector3i getMaxPos() {
        return DEFAULT_MAX;
    }

    public float getAmbientLight();

    public int getWorldSkyLight();

    default public boolean isRenderEdges() {
        return true;
    }

    default public boolean isInsideRenderBoundaries(int x, int z) {
        Vector3i min2 = this.getMinPos();
        Vector3i max = this.getMaxPos();
        return x >= min2.getX() && x <= max.getX() && z >= min2.getZ() && z <= max.getZ();
    }

    default public boolean isInsideRenderBoundaries(int x, int y, int z) {
        Vector3i min2 = this.getMinPos();
        Vector3i max = this.getMaxPos();
        return x >= min2.getX() && x <= max.getX() && z >= min2.getZ() && z <= max.getZ() && y >= min2.getY() && y <= max.getY();
    }

    public boolean isSaveHiresLayer();
}

