/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.TrigMath;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.util.InstancePool;
import de.bluecolored.bluemap.core.util.MergeSort;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import de.bluecolored.bluemap.core.util.math.VectorM3f;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class HiresTileModel {
    private static final double GROW_MULTIPLIER = 1.5;
    private static final int FI_POSITION = 9;
    private static final int FI_UV = 6;
    private static final int FI_AO = 3;
    private static final int FI_COLOR = 3;
    private static final int FI_SUNLIGHT = 1;
    private static final int FI_BLOCKLIGHT = 1;
    private static final int FI_MATERIAL_INDEX = 1;
    private static final InstancePool<HiresTileModel> INSTANCE_POOL = new InstancePool<HiresTileModel>(() -> new HiresTileModel(100), HiresTileModel::clear);
    private int capacity;
    private int size;
    private double[] position;
    private float[] color;
    private float[] uv;
    private float[] ao;
    private byte[] sunlight;
    private byte[] blocklight;
    private int[] materialIndex;
    private int[] materialIndexSort;
    private int[] materialIndexSortSupport;

    public HiresTileModel(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity is negative");
        }
        this.setCapacity(initialCapacity);
        this.clear();
    }

    public int size() {
        return this.size;
    }

    public int add(int count) {
        this.ensureCapacity(count);
        int start = this.size;
        this.size += count;
        return start;
    }

    public HiresTileModel setPositions(int face, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        int index = face * 9;
        this.position[index] = x1;
        this.position[index + 1] = y1;
        this.position[index + 2] = z1;
        this.position[index + 3] = x2;
        this.position[index + 3 + 1] = y2;
        this.position[index + 3 + 2] = z2;
        this.position[index + 6] = x3;
        this.position[index + 6 + 1] = y3;
        this.position[index + 6 + 2] = z3;
        return this;
    }

    public HiresTileModel setUvs(int face, float u1, float v1, float u2, float v2, float u3, float v3) {
        int index = face * 6;
        this.uv[index] = u1;
        this.uv[index + 1] = v1;
        this.uv[index + 2] = u2;
        this.uv[index + 2 + 1] = v2;
        this.uv[index + 4] = u3;
        this.uv[index + 4 + 1] = v3;
        return this;
    }

    public HiresTileModel setAOs(int face, float ao1, float ao2, float ao3) {
        int index = face * 3;
        this.ao[index] = ao1;
        this.ao[index + 1] = ao2;
        this.ao[index + 2] = ao3;
        return this;
    }

    public HiresTileModel setColor(int face, float r, float g2, float b) {
        int index = face * 3;
        this.color[index] = r;
        this.color[index + 1] = g2;
        this.color[index + 2] = b;
        return this;
    }

    public HiresTileModel setSunlight(int face, int sl) {
        this.sunlight[face * 1] = (byte)sl;
        return this;
    }

    public HiresTileModel setBlocklight(int face, int bl) {
        this.blocklight[face * 1] = (byte)bl;
        return this;
    }

    public HiresTileModel setMaterialIndex(int face, int m3) {
        this.materialIndex[face * 1] = m3;
        return this;
    }

    public HiresTileModel rotate(int start, int count, float angle, float axisX, float axisY, float axisZ) {
        double halfAngle = Math.toRadians(angle) * 0.5;
        double q = (double)TrigMath.sin(halfAngle) / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double qx = (double)axisX * q;
        double qy = (double)axisY * q;
        double qz = (double)axisZ * q;
        double qw = TrigMath.cos(halfAngle);
        double qLength = Math.sqrt(qx * qx + qy * qy + qz * qz + qw * qw);
        return this.rotateByQuaternion(start, count, qx /= qLength, qy /= qLength, qz /= qLength, qw /= qLength);
    }

    public HiresTileModel rotate(int start, int count, float pitch, float yaw, float roll) {
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double qy1 = TrigMath.sin(halfYaw);
        double qw1 = TrigMath.cos(halfYaw);
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double qx2 = TrigMath.sin(halfPitch);
        double qw2 = TrigMath.cos(halfPitch);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double qz3 = TrigMath.sin(halfRoll);
        double qw3 = TrigMath.cos(halfRoll);
        double qxA = qw1 * qx2;
        double qyA = qy1 * qw2;
        double qzA = -qy1 * qx2;
        double qwA = qw1 * qw2;
        double qx = qxA * qw3 + qyA * qz3;
        double qy = qyA * qw3 - qxA * qz3;
        double qz = qwA * qz3 + qzA * qw3;
        double qw = qwA * qw3 - qzA * qz3;
        return this.rotateByQuaternion(start, count, qx, qy, qz, qw);
    }

    public HiresTileModel rotateByQuaternion(int start, int count, double qx, double qy, double qz, double qw) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index = face * 9 + i * 3;
                double x = this.position[index];
                double y = this.position[index + 1];
                double z = this.position[index + 2];
                double px = qw * x + qy * z - qz * y;
                double py = qw * y + qz * x - qx * z;
                double pz = qw * z + qx * y - qy * x;
                double pw = -qx * x - qy * y - qz * z;
                this.position[index] = pw * -qx + px * qw - py * qz + pz * qy;
                this.position[index + 1] = pw * -qy + py * qw - pz * qx + px * qz;
                this.position[index + 2] = pw * -qz + pz * qw - px * qy + py * qx;
            }
        }
        return this;
    }

    public HiresTileModel scale(int start, int count, double sx, double sy, double sz) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index;
                int n = index = face * 9 + i * 3;
                this.position[n] = this.position[n] * sx;
                int n2 = index + 1;
                this.position[n2] = this.position[n2] * sy;
                int n3 = index + 2;
                this.position[n3] = this.position[n3] * sz;
            }
        }
        return this;
    }

    public HiresTileModel translate(int start, int count, double dx, double dy, double dz) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index;
                int n = index = face * 9 + i * 3;
                this.position[n] = this.position[n] + dx;
                int n2 = index + 1;
                this.position[n2] = this.position[n2] + dy;
                int n3 = index + 2;
                this.position[n3] = this.position[n3] + dz;
            }
        }
        return this;
    }

    public HiresTileModel transform(int start, int count, MatrixM3f t) {
        return this.transform(start, count, t.m00, t.m01, t.m02, t.m10, t.m11, t.m12, t.m20, t.m21, t.m22);
    }

    public HiresTileModel transform(int start, int count, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return this.transform(start, count, m00, m01, m02, 0.0f, m10, m11, m12, 0.0f, m20, m21, m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public HiresTileModel transform(int start, int count, MatrixM4f t) {
        return this.transform(start, count, t.m00, t.m01, t.m02, t.m03, t.m10, t.m11, t.m12, t.m13, t.m20, t.m21, t.m22, t.m23, t.m30, t.m31, t.m32, t.m33);
    }

    public HiresTileModel transform(int start, int count, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index = face * 9 + i * 3;
                double x = this.position[index];
                double y = this.position[index + 1];
                double z = this.position[index + 2];
                this.position[index] = (double)m00 * x + (double)m01 * y + (double)m02 * z + (double)m03;
                this.position[index + 1] = (double)m10 * x + (double)m11 * y + (double)m12 * z + (double)m13;
                this.position[index + 2] = (double)m20 * x + (double)m21 * y + (double)m22 * z + (double)m23;
            }
        }
        return this;
    }

    public HiresTileModel reset(int size) {
        this.size = size;
        return this;
    }

    public HiresTileModel clear() {
        this.size = 0;
        return this;
    }

    private void ensureCapacity(int count) {
        if (this.size + count > this.capacity) {
            double[] _position = this.position;
            float[] _color = this.color;
            float[] _uv = this.uv;
            float[] _ao = this.ao;
            byte[] _sunlight = this.sunlight;
            byte[] _blocklight = this.blocklight;
            int[] _materialIndex = this.materialIndex;
            int newCapacity = (int)((double)this.capacity * 1.5) + count;
            this.setCapacity(newCapacity);
            System.arraycopy(_position, 0, this.position, 0, this.size * 9);
            System.arraycopy(_uv, 0, this.uv, 0, this.size * 6);
            System.arraycopy(_ao, 0, this.ao, 0, this.size * 3);
            System.arraycopy(_color, 0, this.color, 0, this.size * 3);
            System.arraycopy(_sunlight, 0, this.sunlight, 0, this.size * 1);
            System.arraycopy(_blocklight, 0, this.blocklight, 0, this.size * 1);
            System.arraycopy(_materialIndex, 0, this.materialIndex, 0, this.size * 1);
        }
    }

    private void setCapacity(int capacity) {
        this.capacity = capacity;
        this.position = new double[capacity * 9];
        this.uv = new float[capacity * 6];
        this.ao = new float[capacity * 3];
        this.color = new float[capacity * 3];
        this.sunlight = new byte[capacity * 1];
        this.blocklight = new byte[capacity * 1];
        this.materialIndex = new int[capacity * 1];
        this.materialIndexSort = new int[this.materialIndex.length];
        this.materialIndexSortSupport = new int[this.materialIndex.length];
    }

    public void writeBufferGeometryJson(OutputStream out) throws IOException {
        Gson gson = new GsonBuilder().create();
        JsonWriter json = gson.newJsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 81920));
        json.beginObject();
        json.name("tileGeometry").beginObject();
        json.name("type").value("BufferGeometry");
        json.name("uuid").value(UUID.randomUUID().toString().toUpperCase());
        json.name("data").beginObject();
        json.name("attributes").beginObject();
        this.writePositionArray(json);
        this.writeNormalArray(json);
        this.writeColorArray(json);
        this.writeUvArray(json);
        this.writeAoArray(json);
        this.writeBlocklightArray(json);
        this.writeSunlightArray(json);
        json.endObject();
        this.writeMaterialGroups(json);
        json.endObject();
        json.endObject();
        json.endObject();
        json.flush();
    }

    private void writePositionArray(JsonWriter json) throws IOException {
        json.name("position");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(3L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int posSize = this.size * 9;
        for (int i = 0; i < posSize; ++i) {
            this.writeRounded(json, this.position[i]);
        }
        json.endArray();
        json.endObject();
    }

    private void writeNormalArray(JsonWriter json) throws IOException {
        VectorM3f normal = new VectorM3f(0.0f, 0.0f, 0.0f);
        json.name("normal");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(3L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        for (int i = 0; i < this.size; ++i) {
            int pi = i * 9;
            HiresTileModel.calculateSurfaceNormal(this.position[pi], this.position[pi + 1], this.position[pi + 2], this.position[pi + 3], this.position[pi + 4], this.position[pi + 5], this.position[pi + 6], this.position[pi + 7], this.position[pi + 8], normal);
            for (int j = 0; j < 3; ++j) {
                this.writeRounded(json, normal.x);
                this.writeRounded(json, normal.y);
                this.writeRounded(json, normal.z);
            }
        }
        json.endArray();
        json.endObject();
    }

    private void writeColorArray(JsonWriter json) throws IOException {
        json.name("color");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(3L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int colorSize = this.size * 3;
        for (int i = 0; i < colorSize; i += 3) {
            for (int j = 0; j < 3; ++j) {
                this.writeRounded(json, this.color[i]);
                this.writeRounded(json, this.color[i + 1]);
                this.writeRounded(json, this.color[i + 2]);
            }
        }
        json.endArray();
        json.endObject();
    }

    private void writeUvArray(JsonWriter json) throws IOException {
        json.name("uv");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(2L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int uvSize = this.size * 6;
        for (int i = 0; i < uvSize; ++i) {
            this.writeRounded(json, this.uv[i]);
        }
        json.endArray();
        json.endObject();
    }

    private void writeAoArray(JsonWriter json) throws IOException {
        json.name("ao");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(1L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int aoSize = this.size * 3;
        for (int i = 0; i < aoSize; ++i) {
            this.writeRounded(json, this.ao[i]);
        }
        json.endArray();
        json.endObject();
    }

    private void writeBlocklightArray(JsonWriter json) throws IOException {
        json.name("blocklight");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(1L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int blSize = this.size * 1;
        for (int i = 0; i < blSize; ++i) {
            json.value((long)this.blocklight[i]);
            json.value((long)this.blocklight[i]);
            json.value((long)this.blocklight[i]);
        }
        json.endArray();
        json.endObject();
    }

    private void writeSunlightArray(JsonWriter json) throws IOException {
        json.name("sunlight");
        json.beginObject();
        json.name("type").value("Float32Array");
        json.name("itemSize").value(1L);
        json.name("normalized").value(false);
        json.name("array").beginArray();
        int blSize = this.size * 1;
        for (int i = 0; i < blSize; ++i) {
            json.value((long)this.sunlight[i]);
            json.value((long)this.sunlight[i]);
            json.value((long)this.sunlight[i]);
        }
        json.endArray();
        json.endObject();
    }

    private void writeMaterialGroups(JsonWriter json) throws IOException {
        json.name("groups").beginArray();
        if (this.size > 0) {
            int lastMaterial;
            int miSize = this.size * 1;
            int material = lastMaterial = this.materialIndex[0];
            int groupStart = 0;
            json.beginObject();
            json.name("materialIndex").value((long)material);
            json.name("start").value(0L);
            for (int i = 1; i < miSize; ++i) {
                material = this.materialIndex[i];
                if (material != lastMaterial) {
                    json.name("count").value((long)(i - groupStart) * 3L);
                    json.endObject();
                    groupStart = i;
                    json.beginObject();
                    json.name("materialIndex").value((long)material);
                    json.name("start").value((long)groupStart * 3L);
                }
                lastMaterial = material;
            }
            json.name("count").value((long)(miSize - groupStart) * 3L);
            json.endObject();
        }
        json.endArray();
    }

    private void writeRounded(JsonWriter json, double value) throws IOException {
        double d = (double)Math.round(value * 10000.0) / 10000.0;
        if (d == (double)((long)d)) {
            json.value((long)d);
        } else {
            json.value(d);
        }
    }

    public void sort() {
        if (this.size <= 1) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.materialIndexSort[i] = i;
            this.materialIndexSortSupport[i] = i;
        }
        MergeSort.mergeSortInt(this.materialIndexSort, 0, this.size, this::compareMaterialIndex, this.materialIndexSortSupport);
        for (int i = 0; i < this.size; ++i) {
            int s2 = this.materialIndexSort[i];
            int c = 0;
            while (s2 < i) {
                s2 = this.materialIndexSort[s2];
                if (c++ <= this.size) continue;
                throw new IllegalStateException();
            }
            this.swap(i, s2);
        }
    }

    private int compareMaterialIndex(int i1, int i2) {
        return Integer.compare(this.materialIndex[i1], this.materialIndex[i2]);
    }

    private void swap(int face1, int face2) {
        float vf;
        int i;
        int if1 = face1 * 9;
        int if2 = face2 * 9;
        for (i = 0; i < 9; ++i) {
            double vd = this.position[if1 + i];
            this.position[if1 + i] = this.position[if2 + i];
            this.position[if2 + i] = vd;
        }
        if1 = face1 * 6;
        if2 = face2 * 6;
        for (i = 0; i < 6; ++i) {
            vf = this.uv[if1 + i];
            this.uv[if1 + i] = this.uv[if2 + i];
            this.uv[if2 + i] = vf;
        }
        if1 = face1 * 3;
        if2 = face2 * 3;
        for (i = 0; i < 3; ++i) {
            vf = this.ao[if1 + i];
            this.ao[if1 + i] = this.ao[if2 + i];
            this.ao[if2 + i] = vf;
        }
        if1 = face1 * 3;
        if2 = face2 * 3;
        for (i = 0; i < 3; ++i) {
            vf = this.color[if1 + i];
            this.color[if1 + i] = this.color[if2 + i];
            this.color[if2 + i] = vf;
        }
        byte vb = this.sunlight[face1];
        this.sunlight[face1] = this.sunlight[face2];
        this.sunlight[face2] = vb;
        vb = this.blocklight[face1];
        this.blocklight[face1] = this.blocklight[face2];
        this.blocklight[face2] = vb;
        int vi = this.materialIndex[face1];
        this.materialIndex[face1] = this.materialIndex[face2];
        this.materialIndex[face2] = vi;
    }

    private static void calculateSurfaceNormal(double p1x, double p1y, double p1z, double p2x, double p2y, double p2z, double p3x, double p3y, double p3z, VectorM3f target) {
        p2x -= p1x;
        p3x -= p1x;
        p1x = (p2y -= p1y) * (p3z -= p1z) - (p2z -= p1z) * (p3y -= p1y);
        p1y = p2z * p3x - p2x * p3z;
        p1z = p2x * p3y - p2y * p3x;
        double length = Math.sqrt(p1x * p1x + p1y * p1y + p1z * p1z);
        target.set((float)(p1x /= length), (float)(p1y /= length), (float)(p1z /= length));
    }

    public static InstancePool<HiresTileModel> instancePool() {
        return INSTANCE_POOL;
    }
}

