/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.HiresModelRenderer;
import de.bluecolored.bluemap.core.map.hires.HiresTileModel;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.io.OutputStream;

public class HiresModelManager {
    private final Storage.TileStorage storage;
    private final HiresModelRenderer renderer;
    private final Grid tileGrid;

    public HiresModelManager(Storage.TileStorage storage, ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings, Grid tileGrid) {
        this(storage, new HiresModelRenderer(resourcePack, textureGallery, renderSettings), tileGrid);
    }

    public HiresModelManager(Storage.TileStorage storage, HiresModelRenderer renderer, Grid tileGrid) {
        this.storage = storage;
        this.renderer = renderer;
        this.tileGrid = tileGrid;
    }

    public void render(World world, Vector2i tile, TileMetaConsumer tileMetaConsumer, boolean save) {
        Vector2i tileMin = this.tileGrid.getCellMin(tile);
        Vector2i tileMax = this.tileGrid.getCellMax(tile);
        Vector3i modelMin = new Vector3i(tileMin.getX(), Integer.MIN_VALUE, tileMin.getY());
        Vector3i modelMax = new Vector3i(tileMax.getX(), Integer.MAX_VALUE, tileMax.getY());
        HiresTileModel model = HiresTileModel.instancePool().claimInstance();
        this.renderer.render(world, modelMin, modelMax, model, tileMetaConsumer);
        if (save) {
            model.sort();
            this.save(model, tile);
        }
        HiresTileModel.instancePool().recycleInstance(model);
    }

    private void save(HiresTileModel model, Vector2i tile) {
        try (OutputStream os = this.storage.write(tile);){
            model.writeBufferGeometryJson(os);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save hires model: " + String.valueOf(tile), e);
        }
    }

    public Grid getTileGrid() {
        return this.tileGrid;
    }
}

