/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@DebugDump
public class MapRenderState {
    private final Map<Vector2i, Long> regionRenderTimes = new HashMap<Vector2i, Long>();
    private transient long latestRenderTime = -1L;

    public synchronized void setRenderTime(Vector2i regionPos, long renderTime) {
        this.regionRenderTimes.put(regionPos, renderTime);
        if (this.latestRenderTime != -1L) {
            this.latestRenderTime = renderTime > this.latestRenderTime ? renderTime : -1L;
        }
    }

    public synchronized long getRenderTime(Vector2i regionPos) {
        Long renderTime = this.regionRenderTimes.get(regionPos);
        if (renderTime == null) {
            return -1L;
        }
        return renderTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRenderTime() {
        if (this.latestRenderTime == -1L) {
            MapRenderState mapRenderState = this;
            synchronized (mapRenderState) {
                this.latestRenderTime = this.regionRenderTimes.values().stream().mapToLong(Long::longValue).max().orElse(-1L);
            }
        }
        return this.latestRenderTime;
    }

    public synchronized void reset() {
        this.regionRenderTimes.clear();
    }

    public synchronized void save(OutputStream out) throws IOException {
        try (DataOutputStream dOut = new DataOutputStream(new GZIPOutputStream(out));){
            dOut.writeInt(this.regionRenderTimes.size());
            for (Map.Entry<Vector2i, Long> entry : this.regionRenderTimes.entrySet()) {
                Vector2i regionPos = entry.getKey();
                long renderTime = entry.getValue();
                dOut.writeInt(regionPos.getX());
                dOut.writeInt(regionPos.getY());
                dOut.writeLong(renderTime);
            }
            dOut.flush();
        }
    }

    public synchronized void load(InputStream in) throws IOException {
        this.regionRenderTimes.clear();
        try (DataInputStream dIn = new DataInputStream(new GZIPInputStream(in));){
            int size = dIn.readInt();
            for (int i = 0; i < size; ++i) {
                Vector2i regionPos = new Vector2i(dIn.readInt(), dIn.readInt());
                long renderTime = dIn.readLong();
                this.regionRenderTimes.put(regionPos, renderTime);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

