/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.gson.MarkerGson;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.MapRenderState;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.bluemap.core.map.MapSettingsSerializer;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.HiresModelManager;
import de.bluecolored.bluemap.core.map.lowres.LowresTileManager;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.world.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

@DebugDump
public class BmMap {
    public static final String META_FILE_SETTINGS = "settings.json";
    public static final String META_FILE_TEXTURES = "textures.json";
    public static final String META_FILE_RENDER_STATE = ".rstate";
    public static final String META_FILE_MARKERS = "live/markers.json";
    public static final String META_FILE_PLAYERS = "live/players.json";
    private final String id;
    private final String name;
    private final String worldId;
    private final World world;
    private final Storage storage;
    private final MapSettings mapSettings;
    private final ResourcePack resourcePack;
    private final MapRenderState renderState;
    private final TextureGallery textureGallery;
    private final HiresModelManager hiresModelManager;
    private final LowresTileManager lowresTileManager;
    private final ConcurrentHashMap<String, MarkerSet> markerSets;
    private Predicate<Vector2i> tileFilter;
    private long renderTimeSumNanos;
    private long tilesRendered;

    public BmMap(String id, String name, String worldId, World world, Storage storage, ResourcePack resourcePack, MapSettings settings) throws IOException {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.worldId = Objects.requireNonNull(worldId);
        this.world = Objects.requireNonNull(world);
        this.storage = Objects.requireNonNull(storage);
        this.resourcePack = Objects.requireNonNull(resourcePack);
        this.mapSettings = Objects.requireNonNull(settings);
        this.renderState = new MapRenderState();
        this.loadRenderState();
        this.textureGallery = this.loadTextureGallery();
        this.textureGallery.put(resourcePack);
        this.saveTextureGallery();
        this.hiresModelManager = new HiresModelManager(storage.tileStorage(id, 0), this.resourcePack, this.textureGallery, settings, new Grid(settings.getHiresTileSize(), 2));
        this.lowresTileManager = new LowresTileManager(storage.mapStorage(id), new Grid(settings.getLowresTileSize()), settings.getLodCount(), settings.getLodFactor());
        this.tileFilter = t -> true;
        this.markerSets = new ConcurrentHashMap();
        this.renderTimeSumNanos = 0L;
        this.tilesRendered = 0L;
        this.saveMapSettings();
    }

    public void renderTile(Vector2i tile) {
        if (!this.tileFilter.test(tile)) {
            return;
        }
        long start = System.nanoTime();
        this.hiresModelManager.render(this.world, tile, this.lowresTileManager, this.mapSettings.isSaveHiresLayer());
        long end = System.nanoTime();
        long delta = end - start;
        this.renderTimeSumNanos += delta;
        ++this.tilesRendered;
    }

    public synchronized void save() {
        this.lowresTileManager.save();
        this.saveRenderState();
        this.saveMarkerState();
        this.savePlayerState();
        this.saveMapSettings();
        try {
            if (this.storage.readMetaInfo(this.id, META_FILE_TEXTURES).isEmpty()) {
                this.saveTextureGallery();
            }
        }
        catch (IOException e) {
            Logger.global.logError("Failed to read texture gallery", e);
        }
    }

    private void loadRenderState() throws IOException {
        Optional<InputStream> rstateData = this.storage.readMeta(this.id, META_FILE_RENDER_STATE);
        if (rstateData.isPresent()) {
            try (InputStream in = rstateData.get();){
                this.renderState.load(in);
            }
            catch (IOException ex) {
                Logger.global.logWarning("Failed to load render-state for map '" + this.getId() + "': " + String.valueOf(ex));
            }
        }
    }

    public synchronized void saveRenderState() {
        try (OutputStream out = this.storage.writeMeta(this.id, META_FILE_RENDER_STATE);){
            this.renderState.save(out);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save render-state for map: '" + this.id + "'!", ex);
        }
    }

    private TextureGallery loadTextureGallery() throws IOException {
        TextureGallery gallery = null;
        Optional<InputStream> texturesData = this.storage.readMeta(this.id, META_FILE_TEXTURES);
        if (texturesData.isPresent()) {
            try (InputStream in = texturesData.get();){
                gallery = TextureGallery.readTexturesFile(in);
            }
            catch (IOException ex) {
                Logger.global.logError("Failed to load textures for map '" + this.getId() + "'!", ex);
            }
        }
        return gallery != null ? gallery : new TextureGallery();
    }

    private void saveTextureGallery() {
        try (OutputStream out = this.storage.writeMeta(this.id, META_FILE_TEXTURES);){
            this.textureGallery.writeTexturesFile(out);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save textures for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void resetTextureGallery() {
        this.textureGallery.clear();
        this.textureGallery.put(this.resourcePack);
    }

    private void saveMapSettings() {
        try (OutputStream out = this.storage.writeMeta(this.id, META_FILE_SETTINGS);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            ResourcesGson.addAdapter(new GsonBuilder()).registerTypeAdapter(BmMap.class, (Object)new MapSettingsSerializer()).create().toJson((Object)this, (Appendable)writer);
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save settings for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void saveMarkerState() {
        try (OutputStream out = this.storage.writeMeta(this.id, META_FILE_MARKERS);
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            MarkerGson.INSTANCE.toJson(this.markerSets, (Appendable)writer);
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save markers for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void savePlayerState() {
        try (OutputStream out = this.storage.writeMeta(this.id, META_FILE_PLAYERS);){
            out.write("{}".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save markers for map '" + this.getId() + "'!", ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getWorldId() {
        return this.worldId;
    }

    public World getWorld() {
        return this.world;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public MapSettings getMapSettings() {
        return this.mapSettings;
    }

    public MapRenderState getRenderState() {
        return this.renderState;
    }

    public HiresModelManager getHiresModelManager() {
        return this.hiresModelManager;
    }

    public LowresTileManager getLowresTileManager() {
        return this.lowresTileManager;
    }

    public Map<String, MarkerSet> getMarkerSets() {
        return this.markerSets;
    }

    public Predicate<Vector2i> getTileFilter() {
        return this.tileFilter;
    }

    public void setTileFilter(Predicate<Vector2i> tileFilter) {
        this.tileFilter = tileFilter;
    }

    public long getAverageNanosPerTile() {
        return this.renderTimeSumNanos / this.tilesRendered;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BmMap) {
            BmMap that = (BmMap)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        return "BmMap{id='" + this.id + "', name='" + this.name + "', world=" + String.valueOf(this.world) + ", storage=" + String.valueOf(this.storage) + "}";
    }
}

