/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.SelectionConsumer;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class HttpConnection
implements SelectionConsumer {
    private final HttpRequestHandler requestHandler;
    private final Executor responseHandlerExecutor;
    private HttpRequest request;
    private CompletableFuture<HttpResponse> futureResponse;
    private HttpResponse response;

    public HttpConnection(HttpRequestHandler requestHandler) {
        this(requestHandler, Runnable::run);
    }

    public HttpConnection(HttpRequestHandler requestHandler, Executor responseHandlerExecutor) {
        this.requestHandler = requestHandler;
        this.responseHandlerExecutor = responseHandlerExecutor;
    }

    @Override
    public void accept(SelectionKey selectionKey) {
        if (!selectionKey.isValid()) {
            return;
        }
        SelectableChannel selChannel = selectionKey.channel();
        if (!(selChannel instanceof SocketChannel)) {
            return;
        }
        SocketChannel channel = (SocketChannel)selChannel;
        try {
            if (this.request == null) {
                SocketAddress remote = channel.getRemoteAddress();
                InetAddress remoteInet = null;
                if (remote instanceof InetSocketAddress) {
                    remoteInet = ((InetSocketAddress)remote).getAddress();
                }
                this.request = new HttpRequest(remoteInet);
            }
            if (!this.request.write(channel)) {
                if (!selectionKey.isValid()) {
                    return;
                }
                selectionKey.interestOps(1);
                return;
            }
            if (this.futureResponse == null) {
                this.futureResponse = CompletableFuture.supplyAsync(() -> this.requestHandler.handle(this.request), this.responseHandlerExecutor);
                this.futureResponse.thenAccept(response -> {
                    try {
                        response.read(channel);
                        this.response = response;
                    }
                    catch (IOException e) {
                        this.handleIOException(channel, e);
                    }
                });
            }
            if (this.response == null) {
                return;
            }
            if (!selectionKey.isValid()) {
                return;
            }
            if (!this.response.read(channel)) {
                selectionKey.interestOps(4);
                return;
            }
            this.request.clear();
            this.response.close();
            this.futureResponse = null;
            this.response = null;
            selectionKey.interestOps(1);
        }
        catch (IOException e) {
            this.handleIOException(channel, e);
        }
    }

    private void handleIOException(Channel channel, IOException e) {
        this.request.clear();
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e2) {
                Logger.global.logWarning("Failed to close response: " + String.valueOf(e2));
            }
            this.response = null;
        }
        if (this.futureResponse != null) {
            this.futureResponse.thenAccept(response -> {
                try {
                    response.close();
                }
                catch (IOException e2) {
                    Logger.global.logWarning("Failed to close response: " + String.valueOf(e2));
                }
            });
            this.futureResponse = null;
        }
        Logger.global.logDebug("Failed to process selection: " + String.valueOf(e));
        try {
            channel.close();
        }
        catch (IOException e2) {
            Logger.global.logWarning("Failed to close channel" + String.valueOf(e2));
        }
    }
}

