/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.logger.Logger;

public class LoggingRequestHandler
implements HttpRequestHandler {
    private final HttpRequestHandler delegate;
    private final Logger logger;
    private final String format;

    public LoggingRequestHandler(HttpRequestHandler delegate) {
        this(delegate, Logger.global);
    }

    public LoggingRequestHandler(HttpRequestHandler delegate, Logger logger) {
        this(delegate, "", logger);
    }

    public LoggingRequestHandler(HttpRequestHandler delegate, String format) {
        this(delegate, format, Logger.global);
    }

    public LoggingRequestHandler(HttpRequestHandler delegate, String format, Logger logger) {
        this.delegate = delegate;
        this.format = format;
        this.logger = logger;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        String source;
        String xffSource = source = request.getSource().toString();
        HttpHeader xffHeader = request.getHeader("X-Forwarded-For");
        if (xffHeader != null && !xffHeader.getValues().isEmpty()) {
            xffSource = xffHeader.getValues().get(0);
        }
        String method = request.getMethod();
        String address = request.getAddress();
        String version = request.getVersion();
        HttpResponse response = this.delegate.handle(request);
        HttpStatusCode status = response.getStatusCode();
        int statusCode = status.getCode();
        String statusMessage = status.getMessage();
        String log = String.format(this.format, source, xffSource, method, address, version, statusCode, statusMessage);
        if (statusCode < 500) {
            this.logger.logInfo(log);
        } else {
            this.logger.logWarning(log);
        }
        return response;
    }
}

