/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateFormatUtils;

public class FileRequestHandler
implements HttpRequestHandler {
    private final Path webRoot;
    private final File emptyTileFile;

    public FileRequestHandler(Path webRoot) {
        this.webRoot = webRoot.normalize();
        this.emptyTileFile = webRoot.resolve("assets").resolve("emptyTile.json").toFile();
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return new HttpResponse(HttpStatusCode.BAD_REQUEST);
        }
        return this.generateResponse(request);
    }

    private HttpResponse generateResponse(HttpRequest request) {
        Path filePath;
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            filePath = this.webRoot.resolve(path);
        }
        catch (InvalidPathException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        if (!filePath.normalize().startsWith(this.webRoot)) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        File file = filePath.toFile();
        if (file.isDirectory() && !request.getPath().endsWith("/")) {
            HttpResponse response = new HttpResponse(HttpStatusCode.SEE_OTHER);
            response.addHeader("Location", "/" + path + "/" + (String)(request.getGETParamString().isEmpty() ? "" : "?" + request.getGETParamString()));
            return response;
        }
        if (!file.exists() || file.isDirectory()) {
            file = new File(String.valueOf(filePath) + "/index.html");
        }
        if (!file.exists() && file.toPath().startsWith(this.webRoot.resolve("maps"))) {
            file = this.emptyTileFile;
        }
        if (!file.exists() || file.isDirectory()) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        if (file.getName().endsWith(".php")) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        if (!file.toPath().normalize().startsWith(this.webRoot) || file.isDirectory()) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        long lastModified = file.lastModified();
        HttpHeader modHeader = request.getHeader("If-Modified-Since");
        if (modHeader != null) {
            try {
                long since = FileRequestHandler.stringToTimestamp(modHeader.getValue());
                if (since + 1000L >= lastModified) {
                    return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
                }
            }
            catch (IllegalArgumentException since) {
                // empty catch block
            }
        }
        String eTag = Long.toHexString(file.length()) + Integer.toHexString(file.hashCode()) + Long.toHexString(lastModified);
        HttpHeader etagHeader = request.getHeader("If-None-Match");
        if (etagHeader != null && etagHeader.getValue().equals(eTag)) {
            return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
        }
        HttpResponse response = new HttpResponse(HttpStatusCode.OK);
        response.addHeader("ETag", eTag);
        if (lastModified > 0L) {
            response.addHeader("Last-Modified", FileRequestHandler.timestampToString(lastModified));
        }
        response.addHeader("Cache-Control", "public");
        response.addHeader("Cache-Control", "max-age=" + TimeUnit.HOURS.toSeconds(1L));
        String filetype = file.getName();
        int pointIndex = filetype.lastIndexOf(46);
        if (pointIndex >= 0) {
            filetype = filetype.substring(pointIndex + 1);
        }
        String contentType = FileRequestHandler.toContentType(filetype);
        response.addHeader("Content-Type", contentType);
        try {
            response.setData(new FileInputStream(file));
            return response;
        }
        catch (FileNotFoundException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
    }

    private static String timestampToString(long time) {
        return DateFormatUtils.format((long)time, (String)"EEE, dd MMM yyy HH:mm:ss 'GMT'", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    }

    private static long stringToTimestamp(String timeString) throws IllegalArgumentException {
        try {
            int day = Integer.parseInt(timeString.substring(5, 7));
            int month = 0;
            switch (timeString.substring(8, 11)) {
                case "Feb": {
                    month = 1;
                    break;
                }
                case "Mar": {
                    month = 2;
                    break;
                }
                case "Apr": {
                    month = 3;
                    break;
                }
                case "May": {
                    month = 4;
                    break;
                }
                case "Jun": {
                    month = 5;
                    break;
                }
                case "Jul": {
                    month = 6;
                    break;
                }
                case "Aug": {
                    month = 7;
                    break;
                }
                case "Sep": {
                    month = 8;
                    break;
                }
                case "Oct": {
                    month = 9;
                    break;
                }
                case "Nov": {
                    month = 10;
                    break;
                }
                case "Dec": {
                    month = 11;
                }
            }
            int year = Integer.parseInt(timeString.substring(12, 16));
            int hour = Integer.parseInt(timeString.substring(17, 19));
            int min2 = Integer.parseInt(timeString.substring(20, 22));
            int sec = Integer.parseInt(timeString.substring(23, 25));
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.set(year, month, day, hour, min2, sec);
            return cal.getTimeInMillis();
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String toContentType(String fileEnding) {
        String contentType = "text/plain";
        switch (fileEnding) {
            case "json": {
                contentType = "application/json";
                break;
            }
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpg": 
            case "jpeg": 
            case "jpe": {
                contentType = "image/jpeg";
                break;
            }
            case "svg": {
                contentType = "image/svg+xml";
                break;
            }
            case "css": {
                contentType = "text/css";
                break;
            }
            case "js": {
                contentType = "text/javascript";
                break;
            }
            case "html": 
            case "htm": 
            case "shtml": {
                contentType = "text/html";
                break;
            }
            case "xml": {
                contentType = "text/xml";
            }
        }
        return contentType;
    }
}

