/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.serverinterface;

import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.MinecraftVersion;
import de.bluecolored.bluemap.core.util.Tristate;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public interface ServerInterface {
    @DebugDump
    public MinecraftVersion getMinecraftVersion();

    public void registerListener(ServerEventListener var1);

    public void unregisterAllListeners();

    default public Optional<ServerWorld> getWorld(Path worldFolder) {
        Path normalizedWorldFolder = worldFolder.toAbsolutePath().normalize();
        return this.getLoadedWorlds().stream().filter(world -> world.getSaveFolder().toAbsolutePath().normalize().equals(normalizedWorldFolder)).findAny();
    }

    default public Optional<ServerWorld> getWorld(Object world) {
        return Optional.empty();
    }

    @DebugDump
    public Collection<ServerWorld> getLoadedWorlds();

    @DebugDump
    public Path getConfigFolder();

    @DebugDump
    public Optional<Path> getModsFolder();

    @DebugDump
    default public Tristate isMetricsEnabled() {
        return Tristate.UNDEFINED;
    }

    @DebugDump
    public Collection<Player> getOnlinePlayers();

    public Optional<Player> getPlayer(UUID var1);
}

