/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.common.config.storage.FileConfig;
import de.bluecolored.bluemap.common.config.storage.SQLConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.file.FileStorage;
import de.bluecolored.bluemap.core.storage.sql.SQLStorage;

public enum StorageType {
    FILE(FileConfig.class, FileStorage::new),
    SQL(SQLConfig.class, SQLStorage::create);

    private final Class<? extends StorageConfig> configType;
    private final StorageFactory<? extends StorageConfig> storageFactory;

    private <C extends StorageConfig> StorageType(Class<C> configType, StorageFactory<C> storageFactory) {
        this.configType = configType;
        this.storageFactory = storageFactory;
    }

    public Class<? extends StorageConfig> getConfigType() {
        return this.configType;
    }

    public <C extends StorageConfig> StorageFactory<C> getStorageFactory(Class<C> configType) {
        if (!configType.isAssignableFrom(this.configType)) {
            throw new ClassCastException(String.valueOf(this.configType) + " can not be cast to " + String.valueOf(configType));
        }
        return this.storageFactory;
    }

    @FunctionalInterface
    public static interface StorageFactory<C extends StorageConfig> {
        public Storage provideRaw(C var1) throws Exception;

        default public Storage provide(StorageConfig config) throws Exception {
            return this.provideRaw(config);
        }
    }
}

