/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.nio.file.Path;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

@DebugDump
@ConfigSerializable
public class MapConfig
implements MapSettings {
    private String name = null;
    private Path world = null;
    private int sorting = 0;
    private Vector2i startPos = null;
    private String skyColor = "#7dabff";
    private String voidColor = "#000000";
    private float ambientLight = 0.0f;
    private int worldSkyLight = 15;
    private int removeCavesBelowY = 55;
    private int caveDetectionOceanFloor = 10000;
    private boolean caveDetectionUsesBlockLight = false;
    private int minX = Integer.MIN_VALUE;
    private int maxX = Integer.MAX_VALUE;
    private int minZ = Integer.MIN_VALUE;
    private int maxZ = Integer.MAX_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxY = Integer.MAX_VALUE;
    private transient Vector3i min = null;
    private transient Vector3i max = null;
    private long minInhabitedTime = 0L;
    private int minInhabitedTimeRadius = 0;
    private boolean renderEdges = true;
    private boolean saveHiresLayer = true;
    private String storage = "file";
    private boolean ignoreMissingLightData = false;
    private ConfigurationNode markerSets = null;
    private int hiresTileSize = 32;
    private int lowresTileSize = 500;
    private int lodCount = 3;
    private int lodFactor = 5;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Path getWorld() {
        return this.world;
    }

    @Override
    public int getSorting() {
        return this.sorting;
    }

    @Override
    public Optional<Vector2i> getStartPos() {
        return Optional.ofNullable(this.startPos);
    }

    @Override
    public String getSkyColor() {
        return this.skyColor;
    }

    @Override
    public String getVoidColor() {
        return this.voidColor;
    }

    @Override
    public float getAmbientLight() {
        return this.ambientLight;
    }

    @Override
    public int getWorldSkyLight() {
        return this.worldSkyLight;
    }

    @Override
    public int getRemoveCavesBelowY() {
        return this.removeCavesBelowY;
    }

    @Override
    public boolean isCaveDetectionUsesBlockLight() {
        return this.caveDetectionUsesBlockLight;
    }

    @Override
    public int getCaveDetectionOceanFloor() {
        return this.caveDetectionOceanFloor;
    }

    @Override
    public Vector3i getMinPos() {
        if (this.min == null) {
            this.min = new Vector3i(this.minX, this.minY, this.minZ);
        }
        return this.min;
    }

    @Override
    public Vector3i getMaxPos() {
        if (this.max == null) {
            this.max = new Vector3i(this.maxX, this.maxY, this.maxZ);
        }
        return this.max;
    }

    @Override
    public long getMinInhabitedTime() {
        return this.minInhabitedTime;
    }

    @Override
    public int getMinInhabitedTimeRadius() {
        return this.minInhabitedTimeRadius;
    }

    @Override
    public boolean isRenderEdges() {
        return this.renderEdges;
    }

    @Override
    public boolean isSaveHiresLayer() {
        return this.saveHiresLayer;
    }

    public String getStorage() {
        return this.storage;
    }

    public boolean isIgnoreMissingLightData() {
        return this.ignoreMissingLightData;
    }

    @Nullable
    public ConfigurationNode getMarkerSets() {
        return this.markerSets;
    }

    @Override
    public int getHiresTileSize() {
        return this.hiresTileSize;
    }

    @Override
    public int getLowresTileSize() {
        return this.lowresTileSize;
    }

    @Override
    public int getLodCount() {
        return this.lodCount;
    }

    @Override
    public int getLodFactor() {
        return this.lodFactor;
    }
}

