/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.config.ConfigTemplate;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.typeserializer.Vector2iTypeSerializer;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.shadow.configurate.ConfigurateException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.hocon.HoconConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.AbstractConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.ConfigurationLoader;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class ConfigManager {
    private static final String[] CONFIG_FILE_ENDINGS = new String[]{".conf", ".json"};
    private final Path configRoot;

    public ConfigManager(Path configRoot) {
        this.configRoot = configRoot;
    }

    public <T> T loadConfig(Path rawPath, Class<T> type) throws ConfigurationException {
        Path path = this.findConfigPath(rawPath);
        ConfigurationNode configNode = this.loadConfigFile(path);
        try {
            return Objects.requireNonNull(configNode.get(type));
        }
        catch (SerializationException | NullPointerException ex) {
            throw new ConfigurationException("BlueMap failed to parse this file:\n" + String.valueOf(path) + "\nCheck if the file is correctly formatted and all values are correct!", ex);
        }
    }

    public ConfigurationNode loadConfig(Path rawPath) throws ConfigurationException {
        Path path = this.findConfigPath(rawPath);
        return this.loadConfigFile(path);
    }

    public ConfigTemplate loadConfigTemplate(String resource) throws IOException {
        InputStream in = BlueMap.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Resource not found: " + resource);
        }
        String configTemplate = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        return new ConfigTemplate(configTemplate);
    }

    private ConfigurationNode loadConfigFile(Path path) throws ConfigurationException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ConfigurationException("BlueMap tried to find this file, but it does not exist:\n" + String.valueOf(path));
        }
        if (!Files.isReadable(path)) {
            throw new ConfigurationException("BlueMap tried to read this file, but can not access it:\n" + String.valueOf(path) + "\nCheck if BlueMap has the permission to read this file.");
        }
        try {
            return this.getLoader(path).load();
        }
        catch (ConfigurateException ex) {
            throw new ConfigurationException("BlueMap failed to parse this file:\n" + String.valueOf(path) + "\nCheck if the file is correctly formatted.\n(for example there might be a } or ] or , missing somewhere)", ex);
        }
    }

    public Path getConfigRoot() {
        return this.configRoot;
    }

    public Path findConfigPath(Path rawPath) {
        if (!rawPath.startsWith(this.configRoot)) {
            rawPath = this.configRoot.resolve(rawPath);
        }
        for (String fileEnding : CONFIG_FILE_ENDINGS) {
            if (!rawPath.getFileName().endsWith(fileEnding)) continue;
            return rawPath;
        }
        for (String fileEnding : CONFIG_FILE_ENDINGS) {
            Path path = rawPath.getParent().resolve(String.valueOf(rawPath.getFileName()) + fileEnding);
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path;
        }
        return rawPath.getParent().resolve(String.valueOf(rawPath.getFileName()) + CONFIG_FILE_ENDINGS[0]);
    }

    public boolean isConfigFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        String fileName = path.getFileName().toString();
        for (String fileEnding : CONFIG_FILE_ENDINGS) {
            if (!fileName.endsWith(fileEnding)) continue;
            return true;
        }
        return false;
    }

    public Path getRaw(Path path) {
        String fileName = path.getFileName().toString();
        String rawName = null;
        for (String fileEnding : CONFIG_FILE_ENDINGS) {
            if (!fileName.endsWith(fileEnding)) continue;
            rawName = fileName.substring(0, fileName.length() - fileEnding.length());
            break;
        }
        if (rawName == null) {
            return path;
        }
        return path.getParent().resolve(rawName);
    }

    private ConfigurationLoader<? extends ConfigurationNode> getLoader(Path path) {
        AbstractConfigurationLoader.Builder builder = path.getFileName().endsWith(".json") ? GsonConfigurationLoader.builder() : HoconConfigurationLoader.builder();
        return ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)builder.path(path)).defaultOptions(o -> o.serializers(b -> b.register(Vector2i.class, new Vector2iTypeSerializer())))).build();
    }
}

