/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.WebApp;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class WebAppImpl
implements WebApp {
    private static final Path IMAGE_ROOT_PATH = Path.of("data", "images");
    private final Plugin plugin;

    public WebAppImpl(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Path getWebRoot() {
        return this.plugin.getConfigs().getWebappConfig().getWebroot();
    }

    @Override
    public void setPlayerVisibility(UUID player, boolean visible) {
        if (visible) {
            this.plugin.getPluginState().removeHiddenPlayer(player);
        } else {
            this.plugin.getPluginState().addHiddenPlayer(player);
        }
    }

    @Override
    public boolean getPlayerVisibility(UUID player) {
        return !this.plugin.getPluginState().isPlayerHidden(player);
    }

    @Override
    public void registerScript(String url) {
        this.plugin.getBlueMap().getWebFilesManager().getScripts().add(url);
    }

    @Override
    public void registerStyle(String url) {
        this.plugin.getBlueMap().getWebFilesManager().getStyles().add(url);
    }

    @Override
    @Deprecated(forRemoval=true)
    public String createImage(BufferedImage image, String path) throws IOException {
        path = path.replaceAll("[^a-zA-Z0-9_.\\-/]", "_");
        Path webRoot = this.getWebRoot().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path imageRootFolder = webRoot.resolve(IMAGE_ROOT_PATH);
        Path imagePath = imageRootFolder.resolve(Path.of(path.replace("/", separator) + ".png", new String[0])).toAbsolutePath();
        FileHelper.createDirectories(imagePath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(imagePath);
        Files.createFile(imagePath, new FileAttribute[0]);
        if (!ImageIO.write((RenderedImage)image, "png", imagePath.toFile())) {
            throw new IOException("The format 'png' is not supported!");
        }
        return webRoot.relativize(imagePath).toString().replace(separator, "/");
    }

    @Override
    public Map<String, String> availableImages() throws IOException {
        Path webRoot = this.getWebRoot().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path imageRootPath = webRoot.resolve("data").resolve(IMAGE_ROOT_PATH).toAbsolutePath();
        HashMap<String, String> availableImagesMap = new HashMap<String, String>();
        if (Files.exists(imageRootPath, new LinkOption[0])) {
            try (Stream<Path> fileStream = Files.walk(imageRootPath, new FileVisitOption[0]);){
                fileStream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".png")).map(Path::toAbsolutePath).forEach(p -> {
                    try {
                        String key = imageRootPath.relativize((Path)p).toString();
                        key = key.substring(0, key.length() - 4).replace(separator, "/");
                        String value = webRoot.relativize((Path)p).toString().replace(separator, "/");
                        availableImagesMap.put(key, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
            }
        }
        return availableImagesMap;
    }
}

