/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.api.BlueMapWorldImpl;
import de.bluecolored.bluemap.common.api.PluginImpl;
import de.bluecolored.bluemap.common.api.RenderManagerImpl;
import de.bluecolored.bluemap.common.api.WebAppImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class BlueMapAPIImpl
extends BlueMapAPI {
    private final Plugin plugin;
    private final LoadingCache<Object, Optional<BlueMapWorld>> worldCache;
    private final LoadingCache<String, Optional<BlueMapMap>> mapCache;

    public BlueMapAPIImpl(Plugin plugin) {
        this.plugin = plugin;
        this.worldCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().build(this::getWorldUncached);
        this.mapCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().build(this::getMapUncached);
    }

    @Override
    public RenderManagerImpl getRenderManager() {
        return new RenderManagerImpl(this, this.plugin);
    }

    @Override
    public WebAppImpl getWebApp() {
        return new WebAppImpl(this.plugin);
    }

    @Override
    public de.bluecolored.bluemap.api.plugin.Plugin getPlugin() {
        return new PluginImpl(this.plugin);
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        Map<String, BmMap> maps = this.plugin.getMaps();
        if (maps == null) {
            return Collections.emptyList();
        }
        return maps.values().stream().map(map -> {
            try {
                return new BlueMapMapImpl(this.plugin, (BmMap)map);
            }
            catch (IOException e) {
                Logger.global.logError("[API] Failed to create BlueMapMap for map " + map.getId(), e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Collection<BlueMapWorld> getWorlds() {
        Map<String, World> worlds = this.plugin.getWorlds();
        if (worlds == null) {
            return Collections.emptyList();
        }
        return worlds.values().stream().map(world -> this.getWorld(world).orElse(null)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<BlueMapWorld> getWorld(Object world) {
        return this.worldCache.get(world);
    }

    public Optional<BlueMapWorld> getWorldUncached(Object world) {
        World coreWorld;
        Map<String, World> worlds = this.plugin.getWorlds();
        if (worlds == null) {
            return Optional.empty();
        }
        if (world instanceof UUID && (coreWorld = worlds.get(world.toString())) != null) {
            world = coreWorld;
        }
        if (world instanceof String && (coreWorld = worlds.get(world)) != null) {
            world = coreWorld;
        }
        if (world instanceof World) {
            coreWorld = (World)world;
            try {
                return Optional.of(new BlueMapWorldImpl(this.plugin, coreWorld));
            }
            catch (IOException e) {
                Logger.global.logError("[API] Failed to create BlueMapWorld for world " + String.valueOf(coreWorld.getSaveFolder()), e);
                return Optional.empty();
            }
        }
        ServerWorld serverWorld = this.plugin.getServerInterface().getWorld(world).orElse(null);
        if (serverWorld == null) {
            return Optional.empty();
        }
        try {
            String id = this.plugin.getBlueMap().getWorldId(serverWorld.getSaveFolder());
            World coreWorld2 = worlds.get(id);
            if (coreWorld2 == null) {
                return Optional.empty();
            }
            return Optional.of(new BlueMapWorldImpl(this.plugin, coreWorld2));
        }
        catch (IOException e) {
            Logger.global.logError("[API] Failed to create BlueMapWorld for world " + String.valueOf(serverWorld.getSaveFolder()), e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<BlueMapMap> getMap(String id) {
        return this.mapCache.get(id);
    }

    public Optional<BlueMapMap> getMapUncached(String id) {
        Map<String, BmMap> maps = this.plugin.getMaps();
        if (maps == null) {
            return Optional.empty();
        }
        BmMap map = maps.get(id);
        if (map == null) {
            return Optional.empty();
        }
        BlueMapWorld world = this.getWorld(map.getWorld()).orElse(null);
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(new BlueMapMapImpl(this.plugin, map, (BlueMapWorldImpl)world));
    }

    @Override
    public String getBlueMapVersion() {
        return BlueMap.VERSION;
    }

    public void register() {
        try {
            BlueMapAPI.registerInstance(this);
        }
        catch (ExecutionException ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPI listener threw an exception (onEnable)!", ex.getCause());
        }
    }

    public void unregister() {
        try {
            BlueMapAPI.unregisterInstance(this);
        }
        catch (ExecutionException ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPI listener threw an exception (onDisable)!", ex.getCause());
        }
    }
}

