/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.math;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@DebugDump
public class Line {
    private final Vector3d[] points;
    @Nullable
    private Vector3d min = null;
    @Nullable
    private Vector3d max = null;

    public Line(Vector3d ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("A line has to have at least 2 points!");
        }
        this.points = points;
    }

    public Line(Collection<Vector3d> points) {
        this((Vector3d[])points.toArray(Vector3d[]::new));
    }

    public int getPointCount() {
        return this.points.length;
    }

    public Vector3d getPoint(int i) {
        return this.points[i];
    }

    public Vector3d[] getPoints() {
        return Arrays.copyOf(this.points, this.points.length);
    }

    public Vector3d getMin() {
        if (this.min == null) {
            Vector3d min2 = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                min2 = min2.min(this.points[i]);
            }
            this.min = min2;
        }
        return this.min;
    }

    public Vector3d getMax() {
        if (this.max == null) {
            Vector3d max = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                max = max.max(this.points[i]);
            }
            this.max = max;
        }
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        return Arrays.equals(this.points, line.points);
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<Vector3d> points = new ArrayList<Vector3d>();

        public Builder addPoint(Vector3d point) {
            this.points.add(point);
            return this;
        }

        public Builder addPoints(Vector3d ... points) {
            this.points.addAll(Arrays.asList(points));
            return this;
        }

        public Builder addPoints(Collection<Vector3d> points) {
            this.points.addAll(points);
            return this;
        }

        public Line build() {
            if (this.points.size() < 2) {
                throw new IllegalStateException("A line has to have at least 2 points!");
            }
            return new Line(this.points);
        }
    }
}

