/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.markers.ObjectMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

@DebugDump
public class ShapeMarker
extends ObjectMarker {
    private static final Shape DEFAULT_SHAPE = Shape.createRect(0.0, 0.0, 1.0, 1.0);
    private Shape shape;
    private Collection<Shape> holes = new ArrayList<Shape>();
    private float shapeY;
    private boolean depthTest = true;
    private int lineWidth = 2;
    private Color lineColor = new Color(255, 0, 0, 1.0f);
    private Color fillColor = new Color(200, 0, 0, 0.3f);

    private ShapeMarker() {
        this("", DEFAULT_SHAPE, 0.0f);
    }

    public ShapeMarker(String label, Shape shape, float shapeY) {
        this(label, ShapeMarker.calculateShapeCenter(Objects.requireNonNull(shape, "shape must not be null"), shapeY), shape, shapeY);
    }

    public ShapeMarker(String label, Vector3d position, Shape shape, float shapeY) {
        super("shape", label, position);
        this.shape = Objects.requireNonNull(shape, "shape must not be null");
        this.shapeY = shapeY;
    }

    public Shape getShape() {
        return this.shape;
    }

    public float getShapeY() {
        return this.shapeY;
    }

    public void setShape(Shape shape, float y) {
        this.shape = Objects.requireNonNull(shape, "shape must not be null");
        this.shapeY = y;
    }

    public Collection<Shape> getHoles() {
        return this.holes;
    }

    public void centerPosition() {
        this.setPosition(ShapeMarker.calculateShapeCenter(this.shape, this.shapeY));
    }

    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    public void setDepthTestEnabled(boolean enabled) {
        this.depthTest = enabled;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = Objects.requireNonNull(color, "color must not be null");
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = Objects.requireNonNull(color, "color must not be null");
    }

    public void setColors(Color lineColor, Color fillColor) {
        this.setLineColor(lineColor);
        this.setFillColor(fillColor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShapeMarker that = (ShapeMarker)o;
        if (Float.compare(that.shapeY, this.shapeY) != 0) {
            return false;
        }
        if (this.depthTest != that.depthTest) {
            return false;
        }
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        if (!this.shape.equals(that.shape)) {
            return false;
        }
        if (!this.lineColor.equals(that.lineColor)) {
            return false;
        }
        return this.fillColor.equals(that.fillColor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.shape.hashCode();
        result = 31 * result + (this.shapeY != 0.0f ? Float.floatToIntBits(this.shapeY) : 0);
        result = 31 * result + (this.depthTest ? 1 : 0);
        result = 31 * result + this.lineWidth;
        result = 31 * result + this.lineColor.hashCode();
        result = 31 * result + this.fillColor.hashCode();
        return result;
    }

    private static Vector3d calculateShapeCenter(Shape shape, float shapeY) {
        Vector2d center = shape.getMin().add(shape.getMax()).mul(0.5);
        return new Vector3d(center.getX(), (double)shapeY, center.getY());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ObjectMarker.Builder<ShapeMarker, Builder> {
        Shape shape;
        float shapeY;
        Collection<Shape> holes = new ArrayList<Shape>();
        Boolean depthTest;
        Integer lineWidth;
        Color lineColor;
        Color fillColor;

        public Builder shape(Shape shape, float y) {
            this.shape = shape;
            this.shapeY = y;
            return this;
        }

        public Builder holes(Shape ... holes) {
            this.holes.addAll(Arrays.asList(holes));
            return this;
        }

        public Builder clearHoles() {
            this.holes.clear();
            return this;
        }

        public Builder centerPosition() {
            this.position(null);
            return this;
        }

        public Builder depthTestEnabled(boolean enabled) {
            this.depthTest = enabled;
            return this;
        }

        public Builder lineWidth(int width) {
            this.lineWidth = width;
            return this;
        }

        public Builder lineColor(Color color) {
            this.lineColor = color;
            return this;
        }

        public Builder fillColor(Color color) {
            this.fillColor = color;
            return this;
        }

        @Override
        public ShapeMarker build() {
            ShapeMarker marker = new ShapeMarker(this.checkNotNull(this.label, "label"), this.checkNotNull(this.shape, "shape"), this.shapeY);
            marker.getHoles().addAll(this.holes);
            if (this.depthTest != null) {
                marker.setDepthTestEnabled(this.depthTest);
            }
            if (this.lineWidth != null) {
                marker.setLineWidth(this.lineWidth);
            }
            if (this.lineColor != null) {
                marker.setLineColor(this.lineColor);
            }
            if (this.fillColor != null) {
                marker.setFillColor(this.fillColor);
            }
            return this.build(marker);
        }
    }
}

