/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.markers.DetailMarker;
import de.bluecolored.bluemap.api.markers.DistanceRangedMarker;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

@DebugDump
public abstract class ObjectMarker
extends DistanceRangedMarker
implements DetailMarker {
    private String detail;
    @Nullable
    private String link;
    private boolean newTab;

    public ObjectMarker(String type, String label, Vector3d position) {
        super(type, label, position);
        this.detail = Objects.requireNonNull(label, "label must not be null");
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public void setDetail(String detail) {
        this.detail = Objects.requireNonNull(detail);
    }

    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    public boolean isNewTab() {
        return this.newTab;
    }

    public void setLink(String link, boolean newTab) {
        this.link = Objects.requireNonNull(link, "link must not be null");
        this.newTab = newTab;
    }

    public void removeLink() {
        this.link = null;
        this.newTab = false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMarker that = (ObjectMarker)o;
        if (this.newTab != that.newTab) {
            return false;
        }
        if (!this.detail.equals(that.detail)) {
            return false;
        }
        return Objects.equals(this.link, that.link);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.detail.hashCode();
        result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
        result = 31 * result + (this.newTab ? 1 : 0);
        return result;
    }

    public static abstract class Builder<T extends ObjectMarker, B extends Builder<T, B>>
    extends DistanceRangedMarker.Builder<T, B>
    implements DetailMarker.Builder<B> {
        String detail;
        String link;
        boolean newTab;

        @Override
        public B detail(String detail) {
            this.detail = detail;
            return (B)((Builder)this.self());
        }

        public B link(String link, boolean newTab) {
            this.link = link;
            this.newTab = newTab;
            return (B)((Builder)this.self());
        }

        public B noLink() {
            this.link = null;
            this.newTab = false;
            return (B)((Builder)this.self());
        }

        @Override
        T build(T marker) {
            if (this.detail != null) {
                ((ObjectMarker)marker).setDetail(this.detail);
            }
            if (this.link != null) {
                ((ObjectMarker)marker).setLink(this.link, this.newTab);
            }
            return (T)((ObjectMarker)super.build(marker));
        }
    }
}

