/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import java.util.Objects;

@DebugDump
public abstract class Marker {
    private final String type;
    private String label;
    private Vector3d position;
    private int sorting;
    private boolean listed;

    public Marker(String type, String label, Vector3d position) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.label = Objects.requireNonNull(label, "label cannot be null");
        this.position = Objects.requireNonNull(position, "position cannot be null");
        this.sorting = 0;
        this.listed = true;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = Objects.requireNonNull(label, "label cannot be null").replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = Objects.requireNonNull(position, "position cannot be null");
    }

    public void setPosition(double x, double y, double z) {
        this.setPosition(new Vector3d(x, y, z));
    }

    public int getSorting() {
        return this.sorting;
    }

    public void setSorting(int sorting) {
        this.sorting = sorting;
    }

    public boolean isListed() {
        return this.listed;
    }

    public void setListed(boolean listed) {
        this.listed = listed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker marker = (Marker)o;
        if (!this.type.equals(marker.type)) {
            return false;
        }
        if (!this.label.equals(marker.label)) {
            return false;
        }
        return this.position.equals(marker.position);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.position.hashCode();
        return result;
    }

    @Deprecated(forRemoval=true)
    public void setPosition(int x, int y, int z) {
        this.setPosition(new Vector3d(x, y, z));
    }

    public static abstract class Builder<T extends Marker, B extends Builder<T, B>> {
        String label;
        Vector3d position;
        Integer sorting;
        Boolean listed;

        public B label(String label) {
            this.label = label;
            return this.self();
        }

        public B position(Vector3d position) {
            this.position = position;
            return this.self();
        }

        public B position(double x, double y, double z) {
            return this.position(new Vector3d(x, y, z));
        }

        public B sorting(Integer sorting) {
            this.sorting = sorting;
            return this.self();
        }

        public B listed(Boolean listed) {
            this.listed = listed;
            return this.self();
        }

        public abstract T build();

        T build(T marker) {
            if (this.label != null) {
                ((Marker)marker).setLabel(this.label);
            }
            if (this.position != null) {
                ((Marker)marker).setPosition(this.position);
            }
            if (this.sorting != null) {
                ((Marker)marker).setSorting(this.sorting);
            }
            if (this.listed != null) {
                ((Marker)marker).setListed(this.listed);
            }
            return marker;
        }

        B self() {
            return (B)this;
        }

        <O> O checkNotNull(O object, String name) {
            if (object == null) {
                throw new IllegalStateException(name + " has to be set and cannot be null");
            }
            return object;
        }

        @Deprecated(forRemoval=true)
        public B position(int x, int y, int z) {
            return this.position(new Vector3d(x, y, z));
        }
    }
}

