/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.debug.DebugDump;
import de.bluecolored.bluemap.api.markers.DistanceRangedMarker;
import de.bluecolored.bluemap.api.markers.ElementMarker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@DebugDump
public class HtmlMarker
extends DistanceRangedMarker
implements ElementMarker {
    private Set<String> classes = new HashSet<String>();
    private Vector2i anchor;
    private String html;

    private HtmlMarker() {
        this("", Vector3d.ZERO, "");
    }

    public HtmlMarker(String label, Vector3d position, String html) {
        this(label, position, html, new Vector2i(0, 0));
    }

    public HtmlMarker(String label, Vector3d position, String html, Vector2i anchor) {
        super("html", label, position);
        this.html = Objects.requireNonNull(html, "html must not be null");
        this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
    }

    @Override
    public Vector2i getAnchor() {
        return this.anchor;
    }

    @Override
    public void setAnchor(Vector2i anchor) {
        this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = Objects.requireNonNull(html, "html must not be null");
    }

    @Override
    public Collection<String> getStyleClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    @Override
    public void setStyleClasses(Collection<String> styleClasses) {
        if (!styleClasses.stream().allMatch(STYLE_CLASS_PATTERN.asMatchPredicate())) {
            throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
        }
        this.classes.clear();
        this.classes.addAll(styleClasses);
    }

    @Override
    public void addStyleClasses(Collection<String> styleClasses) {
        if (!styleClasses.stream().allMatch(STYLE_CLASS_PATTERN.asMatchPredicate())) {
            throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
        }
        this.classes.addAll(styleClasses);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HtmlMarker that = (HtmlMarker)o;
        if (!this.anchor.equals(that.anchor)) {
            return false;
        }
        return this.html.equals(that.html);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.anchor.hashCode();
        result = 31 * result + this.html.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DistanceRangedMarker.Builder<HtmlMarker, Builder>
    implements ElementMarker.Builder<Builder> {
        Set<String> classes = new HashSet<String>();
        Vector2i anchor;
        String html;

        @Override
        public Builder anchor(Vector2i anchor) {
            this.anchor = anchor;
            return this;
        }

        public Builder html(String html) {
            this.html = html;
            return this;
        }

        @Override
        public Builder styleClasses(String ... styleClasses) {
            List<String> styleClassesCollection = Arrays.asList(styleClasses);
            if (!styleClassesCollection.stream().allMatch(ElementMarker.STYLE_CLASS_PATTERN.asMatchPredicate())) {
                throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
            }
            this.classes.addAll(styleClassesCollection);
            return this;
        }

        @Override
        public Builder clearStyleClasses() {
            this.classes.clear();
            return this;
        }

        @Override
        public HtmlMarker build() {
            HtmlMarker marker = new HtmlMarker(this.checkNotNull(this.label, "label"), this.checkNotNull(this.position, "position"), this.checkNotNull(this.html, "html"));
            if (this.anchor != null) {
                marker.setAnchor(this.anchor);
            }
            marker.setStyleClasses(this.classes);
            return this.build(marker);
        }
    }
}

