/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PreviewProviderRegistryImpl
implements PreviewProviderRegistry {
    private boolean locked = true;
    private final BiMap<class_2960, PreviewProvider> providerIds = HashBiMap.create();
    private final Map<class_1792, PreviewProvider> providerItems = new HashMap<class_1792, PreviewProvider>();
    public static final PreviewProviderRegistryImpl INSTANCE = new PreviewProviderRegistryImpl();

    private PreviewProviderRegistryImpl() {
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void register(class_2960 id, PreviewProvider provider, Iterable<class_1792> items) {
        if (this.locked) {
            throw new IllegalStateException("attempted to register PreviewProvider outside ShulkerBoxTooltipApi.registerProviders");
        }
        if (this.providerIds.containsValue((Object)provider)) {
            throw new IllegalStateException("attempted to register PreviewProvider twice");
        }
        if (this.providerIds.containsKey((Object)id)) {
            ShulkerBoxTooltip.LOGGER.warn("registering PreviewProvider with an existing id: " + id);
        }
        int priority = provider.getPriority();
        this.providerIds.put((Object)id, (Object)provider);
        for (class_1792 item : items) {
            PreviewProvider previousProvider = this.providerItems.get(item);
            if (previousProvider == null) {
                this.providerItems.put(item, provider);
                continue;
            }
            class_2960 previousId = this.getId(previousProvider);
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            if (priority > previousProvider.getPriority()) {
                ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + previousId + " with " + id + " for item " + itemId);
                this.providerItems.put(item, provider);
                continue;
            }
            ShulkerBoxTooltip.LOGGER.info("overriding preview provider " + id + " with " + previousId + " for item " + itemId);
        }
    }

    @Override
    public void register(class_2960 id, PreviewProvider provider, class_1792 ... items) {
        this.register(id, provider, Arrays.asList(items));
    }

    @Override
    public PreviewProvider get(class_2960 id) {
        return (PreviewProvider)this.providerIds.get((Object)id);
    }

    @Override
    public PreviewProvider get(class_1799 stack) {
        return this.providerItems.get(stack.method_7909());
    }

    @Override
    public PreviewProvider get(class_1792 item) {
        return this.providerItems.get(item);
    }

    @Override
    public class_2960 getId(PreviewProvider provider) {
        return (class_2960)this.providerIds.inverse().get((Object)provider);
    }

    @Override
    @Nonnull
    public Set<class_1792> getItems(PreviewProvider provider) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry<class_1792, PreviewProvider> entry : this.providerItems.entrySet()) {
            if (entry.getValue() != provider) continue;
            builder.add((Object)entry.getKey());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<PreviewProvider> getProviders() {
        return this.providerIds.values();
    }

    @Override
    @Nonnull
    public Set<class_2960> getIds() {
        return this.providerIds.keySet();
    }
}

