/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.fabric;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.RegistrationChangeType;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public final class ServerNetworkingImpl {
    private static final Map<class_2960, ServerNetworking.RegistrationChangeListener> REGISTRATION_CHANGE_LISTENERS = new HashMap<class_2960, ServerNetworking.RegistrationChangeListener>();

    public static void init() {
        if (!ShulkerBoxTooltip.config.server.clientIntegration) {
            return;
        }
        S2CMessages.init();
        C2SMessages.init();
        ServerPlayConnectionEvents.INIT.register((handler, server) -> C2SMessages.registerAllFor(handler.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerNetworking.removeClient(handler.field_14140));
    }

    public static void registerC2SReceiver(class_2960 channelId, class_3222 player, ServerNetworking.PacketReceiver receiver) {
        class_3244 handler = player.field_13987;
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot register packet receiver for " + channelId + ", player is not in game");
            return;
        }
        ServerPlayNetworking.registerReceiver((class_3244)handler, (class_2960)channelId, (server, player1, handler1, buf, responseSender) -> receiver.handle(player1, buf));
    }

    public static void unregisterC2SReceiver(class_2960 channelId, class_3222 player) {
        class_3244 handler = player.field_13987;
        if (handler != null) {
            ServerPlayNetworking.unregisterReceiver((class_3244)handler, (class_2960)channelId);
        }
    }

    public static void addRegistrationChangeListener(class_2960 channelId, ServerNetworking.RegistrationChangeListener listener) {
        REGISTRATION_CHANGE_LISTENERS.put(channelId, listener);
    }

    private static void dispatchRegistrationChangeEvent(class_2960 channelId, class_3222 sender, RegistrationChangeType type) {
        ServerNetworking.RegistrationChangeListener listener = REGISTRATION_CHANGE_LISTENERS.get(channelId);
        if (listener != null) {
            listener.onRegistrationChange(sender, type);
        }
    }

    static {
        S2CPlayChannelEvents.REGISTER.register((handler, sender, server, channels) -> channels.forEach(c -> ServerNetworkingImpl.dispatchRegistrationChangeEvent(c, handler.method_32311(), RegistrationChangeType.REGISTER)));
        S2CPlayChannelEvents.UNREGISTER.register((handler, sender, server, channels) -> channels.forEach(c -> ServerNetworkingImpl.dispatchRegistrationChangeEvent(c, handler.method_32311(), RegistrationChangeType.UNREGISTER)));
    }
}

