/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.registry.EmiTags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_6862;

public interface EmiIngredient
extends EmiRenderable {
    public static final int RENDER_ICON = 1;
    public static final int RENDER_AMOUNT = 2;
    public static final int RENDER_INGREDIENT = 4;
    public static final int RENDER_REMAINDER = 8;

    public List<EmiStack> getEmiStacks();

    default public boolean isEmpty() {
        for (EmiStack stack : this.getEmiStacks()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public EmiIngredient copy();

    public long getAmount();

    public EmiIngredient setAmount(long var1);

    public float getChance();

    public EmiIngredient setChance(float var1);

    @Override
    default public void render(class_332 draw, int x, int y, float delta) {
        this.render(draw, x, y, delta, -1);
    }

    public void render(class_332 var1, int var2, int var3, float var4, int var5);

    public List<class_5684> getTooltip();

    public static boolean areEqual(EmiIngredient a, EmiIngredient b) {
        List<EmiStack> as = a.getEmiStacks();
        List<EmiStack> bs = b.getEmiStacks();
        if (as.size() != bs.size()) {
            return false;
        }
        for (int i = 0; i < as.size(); ++i) {
            if (as.get(i).isEqual(bs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> EmiIngredient of(class_6862<T> key) {
        return EmiIngredient.of(key, 1L);
    }

    public static <T> EmiIngredient of(class_6862<T> key, long amount) {
        return EmiIngredient.of(EmiTags.getRawValues(key), amount);
    }

    public static EmiIngredient of(class_1856 ingredient) {
        if (ingredient == null) {
            return EmiStack.EMPTY;
        }
        class_1799[] stacks = ingredient.method_8105();
        int amount = 1;
        if (stacks.length != 0) {
            amount = stacks[0].method_7947();
            for (int i = 1; i < stacks.length; ++i) {
                if (stacks[i].method_7947() == amount) continue;
                amount = 1;
                break;
            }
        }
        return EmiIngredient.of(ingredient, (long)amount);
    }

    public static EmiIngredient of(class_1856 ingredient, long amount) {
        if (ingredient == null) {
            return EmiStack.EMPTY;
        }
        return EmiTags.getIngredient(class_1792.class, Arrays.stream(ingredient.method_8105()).map(EmiStack::of).toList(), amount);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list) {
        return EmiIngredient.of(list, 1L);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list, long amount) {
        if (list.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        long internalAmount = list.get(0).getAmount();
        for (EmiIngredient emiIngredient : list) {
            if (emiIngredient.getAmount() == internalAmount) continue;
            internalAmount = 1L;
        }
        if (internalAmount > 1L) {
            amount = internalAmount;
            list = list.stream().map(st -> st.copy().setAmount(1L)).toList();
        }
        Class<?> tagType = null;
        for (EmiIngredient emiIngredient : list) {
            for (EmiStack s : emiIngredient.getEmiStacks()) {
                if (s.isEmpty()) continue;
                if (tagType == null) {
                    tagType = EmiTags.ADAPTERS_BY_CLASS.getKey(s.getKey().getClass());
                }
                if (tagType != null && tagType.isAssignableFrom(s.getKey().getClass())) continue;
                return new ListEmiIngredient(list, amount);
            }
        }
        return EmiTags.getIngredient(tagType, list.stream().flatMap(i -> i.getEmiStacks().stream()).toList(), amount);
    }
}

