/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Splitter;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1822;
import net.minecraft.class_1838;
import net.minecraft.class_1841;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_8242;

public class TurtlePlaceCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        class_1799 stack = turtle.getInventory().method_5438(turtle.getSelectedSlot());
        if (stack.method_7960()) {
            return TurtleCommandResult.failure("No items to place");
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_2338 playerPosition = turtle.getPosition().method_10093(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.method_7909() instanceof class_1747 ? "Cannot place block here" : "Cannot place item here");
    }

    private static boolean deploy(class_1799 stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_2350 direction, @Nullable Object[] extraArguments, @Nullable ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(turtle, turtlePlayer)) {
            return true;
        }
        class_2338 position = turtle.getPosition();
        class_2338 newPosition = position.method_10093(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.method_10153(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.method_10093(direction), direction.method_10153(), extraArguments, false, outErrorMessage) || direction.method_10166() != class_2350.class_2351.field_11052 && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.method_10074(), class_2350.field_11036, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        class_243 rayDir;
        class_243 turtlePos;
        class_1937 world = turtle.getLevel();
        class_239 hit = WorldUtil.clip(world, turtlePos = turtlePlayer.player().method_19538(), rayDir = turtlePlayer.player().method_5828(1.0f), 1.5, null);
        if (!(hit instanceof class_3966)) {
            return false;
        }
        class_3966 entityHit = (class_3966)hit;
        class_1297 hitEntity = entityHit.method_17782();
        class_243 hitPos = entityHit.method_17784();
        DropConsumer.set(hitEntity, drop -> InventoryUtil.storeItemsFromOffset((class_1263)turtlePlayer.player().method_31548(), drop, 1));
        boolean placed = PlatformHelper.get().interactWithEntity(turtlePlayer.player(), hitEntity, hitPos);
        TurtleUtil.stopConsuming(turtle);
        return placed;
    }

    private static boolean canDeployOnBlock(class_1750 context, ITurtleAccess turtle, TurtlePlayer player, class_2338 position, class_2350 side, boolean allowReplaceable, @Nullable ErrorMessage outErrorMessage) {
        boolean isProtected;
        class_3218 world = (class_3218)turtle.getLevel();
        if (!world.method_24794(position) || world.method_22347(position) || context.method_8041().method_7909() instanceof class_1747 && WorldUtil.isLiquidBlock((class_1937)world, position)) {
            return false;
        }
        class_2680 state = world.method_8320(position);
        boolean replaceable = state.method_26166(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        boolean bl = isProtected = replaceable ? player.isBlockProtected(world, position) : player.isBlockProtected(world, position.method_10093(side));
        if (isProtected) {
            if (outErrorMessage != null) {
                outErrorMessage.message = "Cannot place in protected area";
            }
            return false;
        }
        return true;
    }

    public static class_3965 getHitResult(class_2338 position, class_2350 side) {
        double hitX = 0.5 + (double)side.method_10148() * 0.5;
        double hitY = 0.5 + (double)side.method_10164() * 0.5;
        double hitZ = 0.5 + (double)side.method_10165() * 0.5;
        if (Math.abs(hitY - 0.5) < 0.01) {
            hitY = 0.45;
        }
        return new class_3965(new class_243((double)position.method_10263() + hitX, (double)position.method_10264() + hitY, (double)position.method_10260() + hitZ), side, position, false);
    }

    private static boolean deployOnBlock(class_1799 stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, class_2338 position, class_2350 side, @Nullable Object[] extraArguments, boolean adjacent, @Nullable ErrorMessage outErrorMessage) {
        Object object;
        class_2350 playerDir = side.method_10153();
        class_2338 playerPosition = position.method_10093(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        class_3965 hit = TurtlePlaceCommand.getHitResult(position, side);
        class_1838 context = new class_1838((class_1657)turtlePlayer.player(), class_1268.field_5808, hit);
        if (!TurtlePlaceCommand.canDeployOnBlock(new class_1750(context), turtle, turtlePlayer, position, side, adjacent, outErrorMessage)) {
            return false;
        }
        class_1792 item = stack.method_7909();
        class_2586 existingTile = turtle.getLevel().method_8321(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, hit, adjacent).method_23665();
        if (placed && item instanceof class_1822 && extraArguments != null && extraArguments.length >= 1 && (object = extraArguments[0]) instanceof String) {
            String message = (String)object;
            class_1937 world = turtle.getLevel();
            class_2586 tile = world.method_8321(position);
            if (tile == null || tile == existingTile) {
                tile = world.method_8321(position.method_10093(side));
            }
            if (tile instanceof class_2625) {
                class_2625 sign = (class_2625)tile;
                TurtlePlaceCommand.setSignText(world, sign, message);
            }
        }
        return placed;
    }

    private static class_1269 doDeployOnBlock(class_1799 stack, TurtlePlayer turtlePlayer, class_3965 hit, boolean adjacent) {
        class_1269 result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit, adjacent ? x -> x.method_26164(ComputerCraftTags.Blocks.TURTLE_CAN_USE) : x -> false);
        if (result != class_1269.field_5811) {
            return result;
        }
        class_1937 level = turtlePlayer.player().method_37908();
        class_1792 item = stack.method_7909();
        if (item instanceof class_1755 || item instanceof class_1841 || stack.method_31573(ComputerCraftTags.Items.TURTLE_CAN_PLACE)) {
            return turtlePlayer.player().field_13974.method_14256(turtlePlayer.player(), level, stack, class_1268.field_5808);
        }
        return class_1269.field_5811;
    }

    private static void setSignText(class_1937 world, class_2625 sign, String message) {
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)message);
        int firstLine = lines.size() <= 2 ? 1 : 0;
        class_8242 signText = new class_8242();
        int len = Math.min(lines.size(), 4);
        for (int i = 0; i < len; ++i) {
            String line = (String)lines.get(i);
            signText = signText.method_49857(i + firstLine, (class_2561)(line.length() > 15 ? class_2561.method_43470((String)line.substring(0, 15)) : class_2561.method_43470((String)line)));
        }
        sign.method_49840(signText, true);
        world.method_8413(sign.method_11016(), sign.method_11010(), sign.method_11010(), 3);
    }

    private static final class ErrorMessage {
        @Nullable
        String message;

        private ErrorMessage() {
        }
    }
}

