/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Contract;

public class TerminalState {
    private final boolean colour;
    private final int width;
    private final int height;
    private final ByteBuf buffer;

    public TerminalState(NetworkedTerminal terminal) {
        this.colour = terminal.isColour();
        this.width = terminal.getWidth();
        this.height = terminal.getHeight();
        ByteBuf buf = this.buffer = Unpooled.buffer();
        terminal.write(new class_2540(buf));
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static TerminalState create(@Nullable NetworkedTerminal terminal) {
        return terminal == null ? null : new TerminalState(terminal);
    }

    public TerminalState(class_2540 buf) {
        this.colour = buf.readBoolean();
        this.width = buf.method_10816();
        this.height = buf.method_10816();
        int length = buf.method_10816();
        this.buffer = buf.readBytes(length);
    }

    public void write(class_2540 buf) {
        buf.writeBoolean(this.colour);
        buf.method_10804(this.width);
        buf.method_10804(this.height);
        buf.method_10804(this.buffer.readableBytes());
        buf.writeBytes(this.buffer, this.buffer.readerIndex(), this.buffer.readableBytes());
    }

    public int size() {
        return this.buffer.readableBytes();
    }

    public void apply(NetworkedTerminal terminal) {
        terminal.resize(this.width, this.height);
        terminal.read(new class_2540(this.buffer));
    }

    public NetworkedTerminal create() {
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(new class_2540(this.buffer));
        return terminal;
    }
}

