/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.MountHelpers;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;

class MountWrapper {
    private final String label;
    private final String location;
    private final Mount mount;
    @Nullable
    private final WritableMount writableMount;

    MountWrapper(String label, String location, Mount mount) {
        this.label = label;
        this.location = location;
        this.mount = mount;
        this.writableMount = null;
    }

    MountWrapper(String label, String location, WritableMount mount) {
        this.label = label;
        this.location = location;
        this.mount = mount;
        this.writableMount = mount;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocation() {
        return this.location;
    }

    public long getFreeSpace() {
        if (this.writableMount == null) {
            return 0L;
        }
        try {
            return this.writableMount.getRemainingSpace();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public OptionalLong getCapacity() {
        return this.writableMount == null ? OptionalLong.empty() : OptionalLong.of(this.writableMount.getCapacity());
    }

    public boolean isReadOnly(String path) throws FileSystemException {
        try {
            return this.writableMount == null || this.writableMount.isReadOnly(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public boolean exists(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.exists(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public boolean isDirectory(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.isDirectory(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void list(String path, List<String> contents) throws FileSystemException {
        path = this.toLocal(path);
        try {
            if (!this.mount.exists(path)) {
                throw this.localExceptionOf(path, "No such file");
            }
            if (!this.mount.isDirectory(path)) {
                throw this.localExceptionOf(path, "Not a directory");
            }
            this.mount.list(path, contents);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public long getSize(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.getSize(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public BasicFileAttributes getAttributes(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.getAttributes(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public SeekableByteChannel openForRead(String path) throws FileSystemException {
        path = this.toLocal(path);
        try {
            return this.mount.openForRead(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void makeDirectory(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            this.writableMount.makeDirectory(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void delete(String path) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            this.writableMount.delete(path);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    public void rename(String source, String dest) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(source, "Access denied");
        }
        source = this.toLocal(source);
        dest = this.toLocal(dest);
        try {
            String destParent;
            if (!(dest.isEmpty() || (destParent = FileSystem.getDirectory(dest)).isEmpty() || this.mount.exists(destParent))) {
                this.writableMount.makeDirectory(destParent);
            }
            this.writableMount.rename(source, dest);
        }
        catch (IOException e) {
            throw this.localExceptionOf(source, e);
        }
    }

    public SeekableByteChannel openForWrite(String path, Set<OpenOption> options) throws FileSystemException {
        if (this.writableMount == null) {
            throw MountWrapper.exceptionOf(path, "Access denied");
        }
        path = this.toLocal(path);
        try {
            String dir;
            if (this.mount.isDirectory(path)) {
                throw this.localExceptionOf(path, options.contains(StandardOpenOption.CREATE) ? "Cannot write to directory" : "Not a file");
            }
            if (options.contains(StandardOpenOption.CREATE) && !(dir = FileSystem.getDirectory(path)).isEmpty() && !this.mount.exists(path)) {
                this.writableMount.makeDirectory(dir);
            }
            return this.writableMount.openFile(path, options);
        }
        catch (IOException e) {
            throw this.localExceptionOf(path, e);
        }
    }

    private String toLocal(String path) {
        return FileSystem.toLocal(path, this.location);
    }

    private FileSystemException localExceptionOf(String localPath, IOException e) {
        IOException ex;
        if (e instanceof FileOperationException && ((FileOperationException)(ex = (FileOperationException)e)).getFilename() != null) {
            return this.localExceptionOf(((FileOperationException)ex).getFilename(), FileSystemException.getMessage(ex));
        }
        if (e instanceof java.nio.file.FileSystemException) {
            ex = (java.nio.file.FileSystemException)e;
            return this.localExceptionOf(localPath, MountHelpers.getReason((java.nio.file.FileSystemException)ex));
        }
        return FileSystemException.of(e);
    }

    private FileSystemException localExceptionOf(String path, String message) {
        if (!this.location.isEmpty()) {
            path = path.isEmpty() ? this.location : this.location + "/" + path;
        }
        return MountWrapper.exceptionOf(path, message);
    }

    private static FileSystemException exceptionOf(String path, String message) {
        return new FileSystemException("/" + path + ": " + message);
    }
}

