/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeDataProvider;
import dan200.computercraft.impl.PlatformHelper;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public abstract class TurtleUpgradeDataProvider
extends UpgradeDataProvider<ITurtleUpgrade, TurtleUpgradeSerialiser<?>> {
    private static final class_2960 TOOL_ID = new class_2960("computercraft", "tool");

    public TurtleUpgradeDataProvider(class_7784 output) {
        super(output, "Turtle Upgrades", "computercraft/turtle_upgrades", TurtleUpgradeSerialiser.registryId());
    }

    public final ToolBuilder tool(class_2960 id, class_1792 item) {
        return new ToolBuilder(id, (TurtleUpgradeSerialiser)this.existingSerialiser(TOOL_ID), item);
    }

    public static class ToolBuilder {
        private final class_2960 id;
        private final TurtleUpgradeSerialiser<?> serialiser;
        private final class_1792 toolItem;
        @Nullable
        private String adjective;
        @Nullable
        private class_1792 craftingItem;
        @Nullable
        private Float damageMultiplier = null;
        @Nullable
        private class_6862<class_2248> breakable;
        private boolean allowEnchantments = false;
        private TurtleToolDurability consumeDurability = TurtleToolDurability.NEVER;

        ToolBuilder(class_2960 id, TurtleUpgradeSerialiser<?> serialiser, class_1792 toolItem) {
            this.id = id;
            this.serialiser = serialiser;
            this.toolItem = toolItem;
            this.craftingItem = null;
        }

        public ToolBuilder adjective(String adjective) {
            this.adjective = adjective;
            return this;
        }

        public ToolBuilder craftingItem(class_1792 craftingItem) {
            this.craftingItem = craftingItem;
            return this;
        }

        public ToolBuilder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = Float.valueOf(damageMultiplier);
            return this;
        }

        public ToolBuilder allowEnchantments() {
            this.allowEnchantments = true;
            return this;
        }

        public ToolBuilder consumeDurability(TurtleToolDurability durability) {
            this.consumeDurability = durability;
            return this;
        }

        public ToolBuilder breakable(class_6862<class_2248> breakable) {
            this.breakable = breakable;
            return this;
        }

        public void add(Consumer<UpgradeDataProvider.Upgrade<TurtleUpgradeSerialiser<?>>> add) {
            add.accept(new UpgradeDataProvider.Upgrade(this.id, this.serialiser, s -> {
                s.addProperty("item", PlatformHelper.get().getRegistryKey(class_7924.field_41197, this.toolItem).toString());
                if (this.adjective != null) {
                    s.addProperty("adjective", this.adjective);
                }
                if (this.craftingItem != null) {
                    s.addProperty("craftItem", PlatformHelper.get().getRegistryKey(class_7924.field_41197, this.craftingItem).toString());
                }
                if (this.damageMultiplier != null) {
                    s.addProperty("damageMultiplier", (Number)this.damageMultiplier);
                }
                if (this.breakable != null) {
                    s.addProperty("breakable", this.breakable.comp_327().toString());
                }
                if (this.allowEnchantments) {
                    s.addProperty("allowEnchantments", Boolean.valueOf(true));
                }
                if (this.consumeDurability != TurtleToolDurability.NEVER) {
                    s.addProperty("consumeDurability", this.consumeDurability.method_15434());
                }
            }));
        }
    }
}

