/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.motor;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;

public class CreativeMotorBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    protected ScrollValueBehaviour generatedSpeed;

    public CreativeMotorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((class_2561)Lang.translateDirect("kinetics.creative_motor.rotation_speed", new Object[0]), this, new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!AllBlocks.CREATIVE_MOTOR.has(this.method_11010())) {
            return 0.0f;
        }
        return CreativeMotorBlockEntity.convertToDirection(this.generatedSpeed.getValue(), (class_2350)this.method_11010().method_11654((class_2769)CreativeMotorBlock.FACING));
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 8.0, 12.5);
        }

        @Override
        public class_243 getLocalOffset(class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            return super.getLocalOffset(state).method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021(-0.0625));
        }

        @Override
        public void rotate(class_2680 state, class_4587 ms) {
            super.rotate(state, ms);
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                return;
            }
            if (this.getSide() != class_2350.field_11036) {
                return;
            }
            TransformStack.cast((class_4587)ms).rotateZ((double)(-AngleHelper.horizontalAngle(facing) + 180.0f));
        }

        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() != class_2350.class_2351.field_11052 && direction == class_2350.field_11033) {
                return false;
            }
            return direction.method_10166() != facing.method_10166();
        }
    }
}

