/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import joptsimple.internal.Strings;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class BoilerData {
    static final int SAMPLE_RATE = 5;
    private static final int waterSupplyPerLevel = 810;
    private static final float passiveEngineEfficiency = 0.125f;
    long gatheredSupply;
    double[] supplyOverTime = new double[10];
    int ticksUntilNextSample;
    int currentIndex;
    public boolean needsHeatLevelUpdate;
    public boolean passiveHeat;
    public int activeHeat;
    public double waterSupply;
    public int attachedEngines;
    public int attachedWhistles;
    private int maxHeatForSize = 0;
    private int maxHeatForWater = 0;
    private int minValue = 0;
    private int maxValue = 0;
    public LerpedFloat gauge = LerpedFloat.linear();

    public void tick(FluidTankBlockEntity controller) {
        if (!this.isActive()) {
            return;
        }
        if (controller.method_10997().field_9236) {
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        long capacity = controller.tankInventory.getCapacity();
        if (capacity == 0L) {
            return;
        }
        this.ticksUntilNextSample = 5;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 5.0f;
        this.waterSupply = Math.max(this.waterSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0L;
        if (this.currentIndex == 0) {
            this.waterSupply = 0.0;
            for (double i : this.supplyOverTime) {
                this.waterSupply = Math.max(i, this.waterSupply);
            }
        }
        if (controller instanceof CreativeFluidTankBlockEntity) {
            this.waterSupply = 16200.0;
        }
        if (this.getActualHeat(controller.getTotalTankSize()) == 18) {
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);
        }
        controller.notifyUpdate();
    }

    public int getTheoreticalHeatLevel() {
        return this.activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int boilerSize) {
        return Math.min(18, boilerSize / 4);
    }

    public int getMaxHeatLevelForWaterSupply() {
        return Math.min(18, class_3532.method_15384((double)this.waterSupply) / 810);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        this.calcMinMaxForSize(boilerSize);
        return this.isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (this.isPassive(boilerSize)) {
            return 0.125f / (float)this.attachedEngines;
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(boilerSize);
        return this.attachedEngines <= actualHeat ? 1.0f : (float)actualHeat / (float)this.attachedEngines;
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        return actualHeat;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking, int boilerSize) {
        if (!this.isActive()) {
            return false;
        }
        class_5250 indent = Components.literal("    ");
        class_5250 indent2 = Components.literal("     ");
        this.calcMinMaxForSize(boilerSize);
        tooltip.add((class_2561)indent.method_27662().method_10852((class_2561)Lang.translateDirect("boiler.status", this.getHeatLevelTextComponent().method_27692(class_124.field_1060))));
        tooltip.add((class_2561)indent2.method_27662().method_10852((class_2561)this.getSizeComponent(true, false, new class_124[0])));
        tooltip.add((class_2561)indent2.method_27662().method_10852((class_2561)this.getWaterComponent(true, false, new class_124[0])));
        tooltip.add((class_2561)indent2.method_27662().method_10852((class_2561)this.getHeatComponent(true, false, new class_124[0])));
        if (this.attachedEngines == 0) {
            return true;
        }
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        double totalSU = (double)(this.getEngineEfficiency(boilerSize) * 16.0f * (float)Math.max(boilerLevel, this.attachedEngines)) * BlockStressValues.getCapacity((class_2248)AllBlocks.STEAM_ENGINE.get());
        tooltip.add(Components.immutableEmpty());
        if (this.attachedEngines > 0 && this.maxHeatForSize > 0 && this.maxHeatForWater == 0 && (this.passiveHeat ? 1 : this.activeHeat) > 0) {
            Lang.translate("boiler.water_input_rate", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            Lang.number(this.waterSupply).style(class_124.field_1078).add(Lang.translate("generic.unit.millibuckets", new Object[0])).add(Lang.text(" / ").style(class_124.field_1080)).add(Lang.translate("boiler.per_tick", Lang.number(810.0).add(Lang.translate("generic.unit.millibuckets", new Object[0]))).style(class_124.field_1063)).forGoggles(tooltip, 1);
            return true;
        }
        Lang.translate("tooltip.capacityProvided", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        Lang.number(totalSU).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add((this.attachedEngines == 1 ? Lang.translate("boiler.via_one_engine", new Object[0]) : Lang.translate("boiler.via_engines", this.attachedEngines)).style(class_124.field_1063)).forGoggles(tooltip, 1);
        return true;
    }

    public void calcMinMaxForSize(int boilerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        this.maxHeatForWater = this.getMaxHeatLevelForWaterSupply();
        this.minValue = Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForWater, this.maxHeatForSize));
    }

    @NotNull
    public class_5250 getHeatLevelTextComponent() {
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        return this.isPassive() ? Lang.translateDirect("boiler.passive", new Object[0]) : (boilerLevel == 0 ? Lang.translateDirect("boiler.idle", new Object[0]) : (boilerLevel == 18 ? Lang.translateDirect("boiler.max_lvl", new Object[0]) : Lang.translateDirect("boiler.lvl", String.valueOf(boilerLevel))));
    }

    public class_5250 getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("water", this.maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public class_5250 getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private class_5250 componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, class_124 ... styles) {
        class_5250 base;
        class_5250 class_52502 = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        class_124 style1 = styles.length >= 1 ? styles[0] : class_124.field_1080;
        class_124 style2 = styles.length >= 2 ? styles[1] : class_124.field_1063;
        return Lang.translateDirect("boiler." + label, new Object[0]).method_27692(style1).method_10852((class_2561)Lang.translateDirect("boiler." + label + "_dots", new Object[0]).method_27692(style2)).method_10852((class_2561)base);
    }

    private class_5250 blockComponent(int level) {
        return Components.literal("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level));
    }

    private class_5250 barComponent(int level) {
        return Components.empty().method_10852((class_2561)this.bars(Math.max(0, this.minValue - 1), class_124.field_1077)).method_10852((class_2561)this.bars(this.minValue > 0 ? 1 : 0, class_124.field_1060)).method_10852((class_2561)this.bars(Math.max(0, level - this.minValue), class_124.field_1077)).method_10852((class_2561)this.bars(Math.max(0, this.maxValue - level), class_124.field_1079)).method_10852((class_2561)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), class_124.field_1063));
    }

    private class_5250 bars(int level, class_124 format) {
        return Components.literal(Strings.repeat((char)'|', (int)level)).method_27692(format);
    }

    public boolean evaluate(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        int prevEngines = this.attachedEngines;
        int prevWhistles = this.attachedWhistles;
        this.attachedEngines = 0;
        this.attachedWhistles = 0;
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (AllBlocks.STEAM_ENGINE.has(attachedState) && SteamEngineBlock.getFacing(attachedState) == d) {
                            ++this.attachedEngines;
                        }
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection(attachedState).method_10153() != d) continue;
                        ++this.attachedWhistles;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedEngines || prevWhistles != this.attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankBlockEntity controller) {
        if (!controller.getBehaviour(AdvancementBehaviour.TYPE).isOwnerPresent()) {
            return;
        }
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        HashSet<Integer> whistlePitches = new HashSet<Integer>();
        for (int yOffset = 0; yOffset < controller.height; ++yOffset) {
            for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
                for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                    class_2338 pos = controllerPos.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = level.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    for (class_2350 d : Iterate.directions) {
                        class_2586 class_25862;
                        class_2338 attachedPos = pos.method_10093(d);
                        class_2680 attachedState = level.method_8320(attachedPos);
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection(attachedState).method_10153() != d || !((class_25862 = level.method_8321(attachedPos)) instanceof WhistleBlockEntity)) continue;
                        WhistleBlockEntity wbe = (WhistleBlockEntity)class_25862;
                        whistlePitches.add(wbe.getPitchId());
                    }
                }
            }
        }
        if (whistlePitches.size() >= 12) {
            controller.award(AllAdvancements.PIPE_ORGAN);
        }
    }

    public boolean updateTemperature(FluidTankBlockEntity controller) {
        class_2338 controllerPos = controller.method_11016();
        class_1937 level = controller.method_10997();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        for (int xOffset = 0; xOffset < controller.width; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.width; ++zOffset) {
                class_2680 blockState;
                class_2338 pos = controllerPos.method_10069(xOffset, -1, zOffset);
                float heat = BoilerHeaters.getActiveHeat(level, pos, blockState = level.method_8320(pos));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public boolean isActive() {
        return this.attachedEngines > 0 || this.attachedWhistles > 0;
    }

    public void clear() {
        this.waterSupply = 0.0;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedEngines = 0;
        Arrays.fill(this.supplyOverTime, 0.0);
    }

    public class_2487 write() {
        class_2487 nbt = new class_2487();
        nbt.method_10549("Supply", this.waterSupply);
        nbt.method_10569("ActiveHeat", this.activeHeat);
        nbt.method_10556("PassiveHeat", this.passiveHeat);
        nbt.method_10569("Engines", this.attachedEngines);
        nbt.method_10569("Whistles", this.attachedWhistles);
        nbt.method_10556("Update", this.needsHeatLevelUpdate);
        return nbt;
    }

    public void read(class_2487 nbt, int boilerSize) {
        this.waterSupply = nbt.method_10574("Supply");
        this.activeHeat = nbt.method_10550("ActiveHeat");
        this.passiveHeat = nbt.method_10577("PassiveHeat");
        this.attachedEngines = nbt.method_10550("Engines");
        this.attachedWhistles = nbt.method_10550("Whistles");
        this.needsHeatLevelUpdate = nbt.method_10577("Update");
        Arrays.fill(this.supplyOverTime, this.waterSupply);
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = this.isPassive(boilerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase(target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler
    extends SmartFluidTank {
        public BoilerFluidHandler() {
            super(810000L, f -> {});
            this.setFluid(FluidStack.EMPTY);
        }

        public boolean isFluidValid(FluidVariant stack) {
            return FluidHelper.isWater(stack.getFluid());
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            if (!this.isFluidValid(insertedVariant)) {
                return 0L;
            }
            BoilerData.this.gatheredSupply += maxAmount;
            return maxAmount;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            return 0L;
        }
    }
}

