/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T> {
    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(class_5614.class_5615 context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean shouldRenderOffScreen(T p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)be.method_10997())) {
            return;
        }
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(be, partialTicks);
        boolean running = this.isRunning(be);
        class_2350.class_2351 rotationAxis = ((IRotate)be.method_11010().method_26204()).getRotationAxis(be.method_11010());
        AbstractPulleyRenderer.kineticRotationTransform(this.getRotatedCoil(be), be, rotationAxis, AngleHelper.rad(offset * 180.0f), light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        class_2338 pos = be.method_11016();
        SuperByteBuffer halfMagnet = CachedBufferer.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBufferer.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = this.renderMagnet(be);
        SuperByteBuffer rope = this.renderRope(be);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (running || offset == 0.0f) {
            AbstractPulleyRenderer.renderAt((class_1936)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            AbstractPulleyRenderer.renderAt((class_1936)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            AbstractPulleyRenderer.renderAt((class_1936)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    public static void renderAt(class_1936 world, SuperByteBuffer partial, float offset, class_2338 pulleyPos, class_4587 ms, class_4588 buffer) {
        class_2338 actualPos = pulleyPos.method_10087((int)offset);
        int light = class_761.method_23793((class_1920)world, (class_2680)world.method_8320(actualPos), (class_2338)actualPos);
        partial.translate(0.0, -offset, 0.0).light(light).renderInto(ms, buffer);
    }

    protected abstract class_2350.class_2351 getShaftAxis(T var1);

    protected abstract PartialModel getCoil();

    protected abstract SuperByteBuffer renderRope(T var1);

    protected abstract SuperByteBuffer renderMagnet(T var1);

    protected abstract float getOffset(T var1, float var2);

    protected abstract boolean isRunning(T var1);

    @Override
    protected class_2680 getRenderedBlockState(T be) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        class_2680 blockState = be.method_11010();
        return CachedBufferer.partialFacing(this.getCoil(), blockState, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.getShaftAxis(be)));
    }

    public int method_33893() {
        return 256;
    }
}

