/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlock;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.render.EmptyLighter;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.gantry.GantryShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.ICoordinate;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import com.simibubi.create.foundation.utility.UniqueLinkedList;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.HashMapPaletteAccessor;
import io.github.fabricators_of_create.porting_lib.util.StickinessUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2361;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2440;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2764;
import net.minecraft.class_2769;
import net.minecraft.class_2814;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4209;
import net.minecraft.class_7225;
import net.minecraft.class_7477;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Contraption {
    public Optional<List<class_238>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;
    public class_238 bounds;
    public class_2338 anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    public boolean disassembled;
    protected Map<class_2338, class_3499.class_3501> blocks = new HashMap<class_2338, class_3499.class_3501>();
    protected List<MutablePair<class_3499.class_3501, MovementContext>> actors;
    protected Map<class_2338, MovingInteractionBehaviour> interactors;
    protected List<class_1799> disabledActors;
    protected List<class_238> superglue;
    protected List<class_2338> seats = new ArrayList<class_2338>();
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    protected MountedStorageManager storage;
    private Set<SuperGlueEntity> glueToRemove;
    private Map<class_2338, class_1297> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    private CompletableFuture<Void> simplifiedEntityColliderProvider;
    public Map<class_2338, class_2586> presentBlockEntities;
    public List<class_2586> maybeInstancedBlockEntities;
    public List<class_2586> specialRenderedBlockEntities;
    protected ContraptionWorld world;
    public boolean deferInvalidate;

    public Contraption() {
        this.actors = new ArrayList<MutablePair<class_3499.class_3501, MovementContext>>();
        this.disabledActors = new ArrayList<class_1799>();
        this.interactors = new HashMap<class_2338, MovingInteractionBehaviour>();
        this.superglue = new ArrayList<class_238>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.glueToRemove = new HashSet<SuperGlueEntity>();
        this.initialPassengers = new HashMap<class_2338, class_1297>();
        this.presentBlockEntities = new HashMap<class_2338, class_2586>();
        this.maybeInstancedBlockEntities = new ArrayList<class_2586>();
        this.specialRenderedBlockEntities = new ArrayList<class_2586>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
        this.simplifiedEntityColliders = Optional.empty();
        this.storage = new MountedStorageManager();
    }

    public ContraptionWorld getContraptionWorld() {
        if (this.world == null) {
            this.world = new ContraptionWorld(this.entity.method_37908(), this);
        }
        return this.world;
    }

    public abstract boolean assemble(class_1937 var1, class_2338 var2) throws AssemblyException;

    public abstract boolean canBeStabilized(class_2350 var1, class_2338 var2);

    public abstract ContraptionType getType();

    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        return false;
    }

    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 forcedDirection, Queue<class_2338> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        String type = nbt.method_10558("Type");
        Contraption contraption = ContraptionType.fromType(type);
        contraption.readNBT(world, nbt, spawnData);
        contraption.world = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(class_1937 world, class_2338 pos, @Nullable class_2350 forcedDirection) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList<class_2338> frontier = new UniqueLinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new class_238(class_2338.field_10980);
        }
        if (!BlockMovementChecks.isBrittle(world.method_8320(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, forcedDirection, frontier, visited)) continue;
            return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            class_2350 face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            class_1937 world = entity.method_37908();
            class_2338 pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos)) {
                }
            }
            catch (AssemblyException e) {}
            continue;
            subContraption.removeBlocksFromWorld(world, class_2338.field_10980);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            class_2338 anchor = blockFace.getConnectedPos();
            movedContraption.method_5814((float)anchor.method_10263() + 0.5f, anchor.method_10264(), (float)anchor.method_10260() + 0.5f);
            world.method_8649((class_1297)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.method_5667(), new BlockFace(this.toLocalPos(pos), face));
        }
        this.storage.createHandlers();
        this.gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
            this.simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(class_1937 world, AbstractContraptionEntity contraptionEntity) {
        if (world.field_9236) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.method_18467(OrientedContraptionEntity.class, contraptionEntity.method_5829().method_1014(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.method_5667())) continue;
            orientedCE.method_5804(contraptionEntity);
        }
        for (class_2338 seatPos : this.getSeats()) {
            int seatIndex;
            class_1297 passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    protected boolean moveBlock(class_1937 world, @Nullable class_2350 forcedDirection, Queue<class_2338> frontier, Set<class_2338> visited) throws AssemblyException {
        class_2350 offset;
        Object attached;
        class_2586 class_25862;
        class_2338 pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (world.method_31606(pos)) {
            return true;
        }
        if (!world.method_8477(pos)) {
            throw AssemblyException.unloadedChunk(pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        class_2680 state = world.method_8320(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return true;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock(pos, state);
        }
        if (state.method_26204() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (AllBlocks.BELT.has(state)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state) && (class_25862 = world.method_8321(pos)) instanceof WindmillBearingBlockEntity) {
            WindmillBearingBlockEntity wbbe = (WindmillBearingBlockEntity)class_25862;
            wbbe.disassembleForMovement();
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (AllBlocks.GANTRY_SHAFT.has(state)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.method_11654((class_2769)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.method_10093(offset = (class_2350)state.method_11654((class_2769)StickerBlock.field_10927))) && !BlockMovementChecks.isNotSupportive(world.method_8320((class_2338)attached), offset.method_10153())) {
            frontier.add((class_2338)attached);
        }
        if (state.method_28498((class_2769)class_2281.field_10770) && state.method_28498((class_2769)class_2281.field_10768) && state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && !visited.contains(attached = pos.method_10093(offset = class_2281.method_9758((class_2680)state)))) {
            frontier.add((class_2338)attached);
        }
        if ((attached = state.method_26204()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)attached;
            for (class_2350 d : bogey.getStickySurfaces((class_1922)world, pos, state)) {
                if (visited.contains(pos.method_10093(d))) continue;
                frontier.add(pos.method_10093(d));
            }
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.method_26204() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.method_26204() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.method_26204() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (MechanicalPistonBlock.isExtensionPole(state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead(state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        class_2338 posDown = pos.method_10074();
        class_2680 stateBelow = world.method_8320(posDown);
        if (!visited.contains(posDown) && AllBlocks.CART_ASSEMBLER.has(stateBelow)) {
            frontier.add(posDown);
        }
        for (class_2350 offset2 : Iterate.directions) {
            boolean canStick;
            class_2338 offsetPos = pos.method_10093(offset2);
            class_2680 blockState = world.method_8320(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock(pos, state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued((class_1936)world, pos, offset2, this.glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset2.method_10153());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean bl = canStick = !brittle && StickinessUtil.canStickTo((class_2680)state, (class_2680)blockState) && StickinessUtil.canStickTo((class_2680)blockState, (class_2680)state);
            if (canStick) {
                if (state.method_26223() == class_3619.field_15970 || blockState.method_26223() == class_3619.field_15970) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset2.method_10153())) {
                    canStick = false;
                }
            }
            if (wasVisited || !canStick && !blockAttachedTowardsFace && !faceHasGlue && (offset2 != forcedDirection || BlockMovementChecks.isNotSupportive(state, forcedDirection))) continue;
            frontier.add(offsetPos);
        }
        this.addBlock(pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 attached;
        class_2350 direction = (class_2350)state.method_11654((class_2769)MechanicalPistonHeadBlock.field_10927);
        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset)) {
            class_2350 pistonFacing;
            class_2680 blockState = world.method_8320(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((class_2350)blockState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == direction.method_10166()) {
                frontier.add(offset);
            }
            if (blockState.method_26204() instanceof MechanicalPistonBlock && (pistonFacing = (class_2350)blockState.method_11654((class_2769)MechanicalPistonBlock.FACING)) == direction && blockState.method_11654(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                frontier.add(offset);
            }
        }
        if (state.method_11654(MechanicalPistonHeadBlock.TYPE) == class_2764.field_12634 && !visited.contains(attached = pos.method_10093(direction))) {
            frontier.add(attached);
        }
    }

    protected void movePistonPole(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directionsInAxis(((class_2350)state.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166())) {
            class_2350 pistonFacing;
            class_2338 offset = pos.method_10093(d);
            if (visited.contains(offset)) continue;
            class_2680 blockState = world.method_8320(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((class_2350)blockState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == d.method_10166()) {
                frontier.add(offset);
            }
            if (MechanicalPistonBlock.isPistonHead(blockState) && ((class_2350)blockState.method_11654((class_2769)MechanicalPistonHeadBlock.field_10927)).method_10166() == d.method_10166()) {
                frontier.add(offset);
            }
            if (!(blockState.method_26204() instanceof MechanicalPistonBlock) || (pistonFacing = (class_2350)blockState.method_11654((class_2769)MechanicalPistonBlock.FACING)) != d && (pistonFacing != d.method_10153() || blockState.method_11654(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.EXTENDED)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryPinion(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 offset = pos.method_10093((class_2350)state.method_11654((class_2769)GantryCarriageBlock.FACING));
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
        class_2350.class_2351 rotationAxis = ((IRotate)state.method_26204()).getRotationAxis(state);
        for (class_2350 d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.method_10093(d);
            class_2680 offsetState = world.method_8320(offset);
            if (!AllBlocks.GANTRY_SHAFT.has(offsetState) || ((class_2350)offsetState.method_11654((class_2769)GantryShaftBlock.FACING)).method_10166() != d.method_10166() || visited.contains(offset)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryShaft(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        for (class_2350 d : Iterate.directions) {
            class_2338 offset = pos.method_10093(d);
            if (visited.contains(offset)) continue;
            class_2680 offsetState = world.method_8320(offset);
            class_2350 facing = (class_2350)state.method_11654((class_2769)GantryShaftBlock.FACING);
            if (d.method_10166() == facing.method_10166() && AllBlocks.GANTRY_SHAFT.has(offsetState) && offsetState.method_11654((class_2769)GantryShaftBlock.FACING) == facing) {
                frontier.add(offset);
                continue;
            }
            if (!AllBlocks.GANTRY_CARRIAGE.has(offsetState) || offsetState.method_11654((class_2769)GantryCarriageBlock.FACING) != d) continue;
            frontier.add(offset);
        }
    }

    private void moveWindmillBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)WindmillBearingBlock.FACING);
        class_2338 offset = pos.method_10093(facing);
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
    }

    private void moveBearing(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)MechanicalBearingBlock.FACING);
        if (!this.canBeStabilized(facing, pos.method_10059((class_2382)this.anchor))) {
            class_2338 offset = pos.method_10093(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) {
        class_2338 nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        class_2338 prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(class_1937 world, class_2338 pos) {
        SeatEntity seat;
        List passengers;
        class_2338 local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.method_18467(SeatEntity.class, new class_238(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.get(0))).method_5685()).isEmpty()) {
            this.initialPassengers.put(local, (class_1297)passengers.get(0));
        }
    }

    private void movePulley(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited) {
        int limit = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        class_2338 ropePos = pos;
        while (limit-- >= 0 && world.method_8477(ropePos = ropePos.method_10074())) {
            class_2680 ropeState = world.method_8320(ropePos);
            class_2248 block = ropeState.method_26204();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(class_1937 world, class_2338 pos, Queue<class_2338> frontier, Set<class_2338> visited, class_2680 state) throws AssemblyException {
        class_2680 poleState;
        class_2350 direction = (class_2350)state.method_11654((class_2769)MechanicalPistonBlock.FACING);
        MechanicalPistonBlock.PistonState pistonState = (MechanicalPistonBlock.PistonState)((Object)state.method_11654(MechanicalPistonBlock.STATE));
        if (pistonState == MechanicalPistonBlock.PistonState.MOVING) {
            return false;
        }
        class_2338 offset = pos.method_10093(direction.method_10153());
        if (!visited.contains(offset) && AllBlocks.PISTON_EXTENSION_POLE.has(poleState = world.method_8320(offset)) && ((class_2350)poleState.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() == direction.method_10166()) {
            frontier.add(offset);
        }
        if ((pistonState == MechanicalPistonBlock.PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) && !visited.contains(offset = pos.method_10093(direction))) {
            frontier.add(offset);
        }
        return true;
    }

    private boolean moveChassis(class_1937 world, class_2338 pos, class_2350 movementDirection, Queue<class_2338> frontier, Set<class_2338> visited) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof ChassisBlockEntity)) {
            return false;
        }
        ChassisBlockEntity chassis = (ChassisBlockEntity)be;
        chassis.addAttachedChasses(frontier, visited);
        List<class_2338> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (class_2338 blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2680 blockstate = world.method_8320(pos);
        if (AllBlocks.REDSTONE_CONTACT.has(blockstate)) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (AllBlocks.POWERED_SHAFT.has(blockstate)) {
            blockstate = BlockHelper.copyProperties(blockstate, AllBlocks.SHAFT.getDefaultState());
        }
        if (blockstate.method_26204() instanceof ControlsBlock && this.getType() == ContraptionType.CARRIAGE) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)ControlsBlock.OPEN, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.method_28498((class_2769)SlidingDoorBlock.VISIBLE)) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.method_26204() instanceof class_2269) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(false));
            world.method_39279(pos, blockstate.method_26204(), -1);
        }
        if (blockstate.method_26204() instanceof class_2440) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)class_2440.field_11358, (Comparable)Boolean.valueOf(false));
            world.method_39279(pos, blockstate.method_26204(), -1);
        }
        class_2487 compoundnbt = this.getBlockEntityNBT(world, pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity) {
            blockEntity = AllBlockEntityTypes.BRACKETED_KINETIC.create(pos, blockstate);
        }
        return Pair.of((Object)new class_3499.class_3501(pos, blockstate, compoundnbt), (Object)blockEntity);
    }

    protected void addBlock(class_2338 pos, Pair<class_3499.class_3501, class_2586> pair) {
        MovingInteractionBehaviour interactionBehaviour;
        class_3499.class_3501 structureBlockInfo;
        class_3499.class_3501 captured = (class_3499.class_3501)pair.getKey();
        class_2338 localPos = pos.method_10059((class_2382)this.anchor);
        if (this.blocks.put(localPos, structureBlockInfo = new class_3499.class_3501(localPos, captured.comp_1342(), captured.comp_1343())) != null) {
            return;
        }
        this.bounds = this.bounds.method_991(new class_238(localPos));
        class_2586 be = (class_2586)pair.getValue();
        this.storage.addBlock(localPos, be);
        if (AllMovementBehaviours.getBehaviour(captured.comp_1342()) != null) {
            this.actors.add((MutablePair<class_3499.class_3501, MovementContext>)MutablePair.of((Object)structureBlockInfo, null));
        }
        if ((interactionBehaviour = AllInteractionBehaviours.getBehaviour(captured.comp_1342())) != null) {
            this.interactors.put(localPos, interactionBehaviour);
        }
        if (be instanceof CreativeCrateBlockEntity && ((CreativeCrateBlockEntity)be).getBehaviour(FilteringBehaviour.TYPE).getFilter().method_7960()) {
            this.hasUniversalCreativeCrate = true;
        }
    }

    @Nullable
    protected class_2487 getBlockEntityNBT(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return null;
        }
        class_2487 nbt = blockEntity.method_38242();
        nbt.method_10551("x");
        nbt.method_10551("y");
        nbt.method_10551("z");
        if ((blockEntity instanceof FluidTankBlockEntity || blockEntity instanceof ItemVaultBlockEntity) && nbt.method_10545("Controller")) {
            nbt.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.toLocalPos(class_2512.method_10691((class_2487)nbt.method_10562("Controller")))));
        }
        return nbt;
    }

    protected class_2338 toLocalPos(class_2338 globalPos) {
        return globalPos.method_10059((class_2382)this.anchor);
    }

    protected boolean movementAllowed(class_2680 state, class_1937 world, class_2338 pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pos.equals((Object)this.anchor);
    }

    public void readNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        this.blocks.clear();
        this.presentBlockEntities.clear();
        this.specialRenderedBlockEntities.clear();
        class_2520 blocks = nbt.method_10580("Blocks");
        boolean usePalettedDeserialization = blocks != null && blocks.method_10711() == 10 && ((class_2487)blocks).method_10545("Palette");
        this.readBlocksCompound(blocks, world, usePalettedDeserialization);
        this.actors.clear();
        nbt.method_10554("Actors", 10).forEach(c -> {
            class_2487 comp = (class_2487)c;
            class_3499.class_3501 info = this.blocks.get(class_2512.method_10691((class_2487)comp.method_10562("Pos")));
            if (info == null) {
                return;
            }
            MovementContext context = MovementContext.readNBT(world, info, comp, this);
            this.getActors().add((MutablePair<class_3499.class_3501, MovementContext>)MutablePair.of((Object)info, (Object)context));
        });
        this.disabledActors = NBTHelper.readItemList(nbt.method_10554("DisabledActors", 10));
        for (class_1799 stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
        this.superglue.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Superglue", 10), c -> this.superglue.add(SuperGlueEntity.readBoundingBox(c)));
        this.seats.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Seats", 10), c -> this.seats.add(class_2512.method_10691((class_2487)c)));
        this.seatMapping.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Passengers", 10), c -> this.seatMapping.put(class_2512.method_25930((class_2520)NBTHelper.getINBT(c, "Id")), c.method_10550("Seat")));
        this.stabilizedSubContraptions.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("SubContraptions", 10), c -> this.stabilizedSubContraptions.put(c.method_25926("Id"), BlockFace.fromNBT(c.method_10562("Location"))));
        this.interactors.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Interactors", 10), c -> {
            class_2338 pos = class_2512.method_10691((class_2487)c.method_10562("Pos"));
            class_3499.class_3501 structureBlockInfo = this.getBlocks().get(pos);
            if (structureBlockInfo == null) {
                return;
            }
            MovingInteractionBehaviour behaviour = AllInteractionBehaviours.getBehaviour(structureBlockInfo.comp_1342());
            if (behaviour != null) {
                this.interactors.put(pos, behaviour);
            }
        });
        this.storage.read(nbt, this.presentBlockEntities, spawnData);
        if (nbt.method_10545("BoundsFront")) {
            this.bounds = NBTHelper.readAABB(nbt.method_10554("BoundsFront", 5));
        }
        this.stalled = nbt.method_10577("Stalled");
        this.hasUniversalCreativeCrate = nbt.method_10577("BottomlessSupply");
        this.anchor = class_2512.method_10691((class_2487)nbt.method_10562("Anchor"));
    }

    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Type", this.getType().id);
        class_2487 blocksNBT = this.writeBlocksCompound();
        class_2499 actorsNBT = new class_2499();
        for (MutablePair<class_3499.class_3501, MovementContext> actor : this.getActors()) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)actor.left).comp_1342());
            if (behaviour == null) continue;
            class_2487 class_24872 = new class_2487();
            class_24872.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_3499.class_3501)actor.left).comp_1341()));
            behaviour.writeExtraData((MovementContext)actor.right);
            ((MovementContext)actor.right).writeToNBT(class_24872);
            actorsNBT.add((Object)class_24872);
        }
        class_2499 disabledActorsNBT = NBTHelper.writeItemList(this.disabledActors);
        class_2499 superglueNBT = new class_2499();
        if (!spawnPacket) {
            for (class_238 class_2384 : this.superglue) {
                class_2487 c = new class_2487();
                SuperGlueEntity.writeBoundingBox(c, class_2384);
                superglueNBT.add((Object)c);
            }
        }
        (spawnPacket ? this.getStorageForSpawnPacket() : this.storage).write(nbt, spawnPacket);
        class_2499 interactorNBT = new class_2499();
        for (class_2338 pos : this.interactors.keySet()) {
            class_2487 c = new class_2487();
            c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
            interactorNBT.add((Object)c);
        }
        nbt.method_10566("Seats", (class_2520)NBTHelper.writeCompoundList(this.getSeats(), class_2512::method_10692));
        nbt.method_10566("Passengers", (class_2520)NBTHelper.writeCompoundList(this.getSeatMapping().entrySet(), e -> {
            class_2487 tag = new class_2487();
            tag.method_10566("Id", (class_2520)class_2512.method_25929((UUID)((UUID)e.getKey())));
            tag.method_10569("Seat", ((Integer)e.getValue()).intValue());
            return tag;
        }));
        nbt.method_10566("SubContraptions", (class_2520)NBTHelper.writeCompoundList(this.stabilizedSubContraptions.entrySet(), e -> {
            class_2487 tag = new class_2487();
            tag.method_25927("Id", (UUID)e.getKey());
            tag.method_10566("Location", (class_2520)((BlockFace)e.getValue()).serializeNBT());
            return tag;
        }));
        nbt.method_10566("Blocks", (class_2520)blocksNBT);
        nbt.method_10566("Actors", (class_2520)actorsNBT);
        nbt.method_10566("DisabledActors", (class_2520)disabledActorsNBT);
        nbt.method_10566("Interactors", (class_2520)interactorNBT);
        nbt.method_10566("Superglue", (class_2520)superglueNBT);
        nbt.method_10566("Anchor", (class_2520)class_2512.method_10692((class_2338)this.anchor));
        nbt.method_10556("Stalled", this.stalled);
        nbt.method_10556("BottomlessSupply", this.hasUniversalCreativeCrate);
        if (this.bounds != null) {
            class_2499 class_24992 = NBTHelper.writeAABB(this.bounds);
            nbt.method_10566("BoundsFront", (class_2520)class_24992);
        }
        return nbt;
    }

    protected MountedStorageManager getStorageForSpawnPacket() {
        return this.storage;
    }

    private class_2487 writeBlocksCompound() {
        class_2487 compound = new class_2487();
        class_2814 palette = new class_2814((class_2359)new class_2361(), 16, (i, s) -> {
            throw new IllegalStateException("Palette Map index exceeded maximum");
        });
        class_2499 blockList = new class_2499();
        for (class_3499.class_3501 block : this.blocks.values()) {
            int id = palette.method_12291((Object)block.comp_1342());
            class_2487 c = new class_2487();
            c.method_10544("Pos", block.comp_1341().method_10063());
            c.method_10569("State", id);
            if (block.comp_1343() != null) {
                c.method_10566("Data", (class_2520)block.comp_1343());
            }
            blockList.add((Object)c);
        }
        class_2499 paletteNBT = new class_2499();
        for (int i2 = 0; i2 < palette.method_12197(); ++i2) {
            paletteNBT.add((Object)class_2512.method_10686((class_2680)((class_2680)((HashMapPaletteAccessor)palette).port_lib$getValues().method_10200(i2))));
        }
        compound.method_10566("Palette", (class_2520)paletteNBT);
        compound.method_10566("BlockList", (class_2520)blockList);
        return compound;
    }

    private void readBlocksCompound(class_2520 compound, class_1937 world, boolean usePalettedDeserialization) {
        class_2499 blockList;
        class_7225 holderGetter = world.method_45448(class_7924.field_41254);
        class_2814 palette = null;
        if (usePalettedDeserialization) {
            class_2487 c = (class_2487)compound;
            palette = new class_2814((class_2359)new class_2361(), 16, (i, s) -> {
                throw new IllegalStateException("Palette Map index exceeded maximum");
            });
            class_2499 list = c.method_10554("Palette", 10);
            ((HashMapPaletteAccessor)palette).port_lib$getValues().method_15229();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((HashMapPaletteAccessor)palette).port_lib$getValues().method_15225((Object)class_2512.method_10681((class_7871)holderGetter, (class_2487)list.method_10602(i2)));
            }
            blockList = c.method_10554("BlockList", 10);
        } else {
            blockList = (class_2499)compound;
        }
        class_2814 finalPalette = palette;
        blockList.forEach(arg_0 -> this.lambda$readBlocksCompound$10(usePalettedDeserialization, finalPalette, (class_7871)holderGetter, world, arg_0));
    }

    private static class_3499.class_3501 readStructureBlockInfo(class_2487 blockListEntry, class_2814<class_2680> palette) {
        return new class_3499.class_3501(class_2338.method_10092((long)blockListEntry.method_10537("Pos")), Objects.requireNonNull((class_2680)palette.method_12288(blockListEntry.method_10550("State"))), blockListEntry.method_10545("Data") ? blockListEntry.method_10562("Data") : null);
    }

    private static class_3499.class_3501 legacyReadStructureBlockInfo(class_2487 blockListEntry, class_7871<class_2248> holderGetter) {
        return new class_3499.class_3501(class_2512.method_10691((class_2487)blockListEntry.method_10562("Pos")), class_2512.method_10681(holderGetter, (class_2487)blockListEntry.method_10562("Block")), blockListEntry.method_10545("Data") ? blockListEntry.method_10562("Data") : null);
    }

    public void removeBlocksFromWorld(class_1937 world, class_2338 offset) {
        this.storage.removeStorageFromWorld();
        this.glueToRemove.forEach(glue -> {
            this.superglue.add(glue.method_5829().method_997(class_243.method_24954((class_2382)offset.method_10081((class_2382)this.anchor)).method_1021(-1.0)));
            glue.method_31472();
        });
        ArrayList<class_3341> minimisedGlue = new ArrayList<class_3341>();
        for (int i = 0; i < this.superglue.size(); ++i) {
            minimisedGlue.add(null);
        }
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<class_3499.class_3501> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                class_3499.class_3501 block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.comp_1342())) continue;
                for (int i = 0; i < this.superglue.size(); ++i) {
                    class_238 aabb = this.superglue.get(i);
                    if (aabb == null || !aabb.method_1008((double)block.comp_1341().method_10263() + 0.5, (double)block.comp_1341().method_10264() + 0.5, (double)block.comp_1341().method_10260() + 0.5)) continue;
                    if (minimisedGlue.get(i) == null) {
                        minimisedGlue.set(i, new class_3341(block.comp_1341()));
                        continue;
                    }
                    minimisedGlue.set(i, BBHelper.encapsulate((class_3341)minimisedGlue.get(i), block.comp_1341()));
                }
                class_2338 add = block.comp_1341().method_10081((class_2382)this.anchor).method_10081((class_2382)offset);
                if (this.customBlockRemoval((class_1936)world, add, block.comp_1342())) continue;
                class_2680 oldState = world.method_8320(add);
                class_2248 blockIn = oldState.method_26204();
                boolean blockMismatch = block.comp_1342().method_26204() != blockIn;
                if (blockMismatch &= !AllBlocks.POWERED_SHAFT.is((Object)blockIn) || !AllBlocks.SHAFT.has(block.comp_1342())) {
                    iterator.remove();
                }
                world.method_8544(add);
                int flags = 122;
                if (blockIn instanceof class_3737 && oldState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    world.method_8652(add, class_2246.field_10382.method_9564(), flags);
                    continue;
                }
                world.method_8652(add, class_2246.field_10124.method_9564(), flags);
            }
        }
        this.superglue.clear();
        Object object = minimisedGlue.iterator();
        while (object.hasNext()) {
            class_238 bb;
            class_3341 box = (class_3341)object.next();
            if (box == null || !((bb = new class_238((double)box.method_35415(), (double)box.method_35416(), (double)box.method_35417(), (double)(box.method_35418() + 1), (double)(box.method_35419() + 1), (double)(box.method_35420() + 1))).method_995() > 1.01)) continue;
            this.superglue.add(bb);
        }
        for (class_3499.class_3501 block : this.blocks.values()) {
            class_2338 add = block.comp_1341().method_10081((class_2382)this.anchor).method_10081((class_2382)offset);
            int flags = 67;
            world.method_8413(add, block.comp_1342(), class_2246.field_10124.method_9564(), flags);
            class_3218 serverWorld = (class_3218)world;
            class_7477.method_43989((class_2680)block.comp_1342()).ifPresent(poiType -> world.method_8503().execute(() -> {
                serverWorld.method_19494().method_19115(add, poiType);
                class_4209.method_19776((class_3218)serverWorld, (class_2338)add);
            }));
            world.markAndNotifyBlock(add, world.method_8500(add), block.comp_1342(), class_2246.field_10124.method_9564(), flags, 512);
            block.comp_1342().method_30102((class_1936)world, add, flags & 0xFFFFFFFE);
        }
    }

    public void addBlocksToWorld(class_1937 world, StructureTransform transform) {
        if (this.disassembled) {
            return;
        }
        this.disassembled = true;
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (class_3499.class_3501 block : this.blocks.values()) {
                class_2680 blockState;
                class_2680 state;
                class_2338 targetPos;
                if (nonBrittles == BlockMovementChecks.isBrittle(block.comp_1342()) || this.customBlockPlacement((class_1936)world, targetPos = transform.apply(block.comp_1341()), state = transform.apply(block.comp_1342()))) continue;
                if (nonBrittles) {
                    for (class_2350 face : Iterate.directions) {
                        state = state.method_26191(face, world.method_8320(targetPos.method_10093(face)), (class_1936)world, targetPos, targetPos.method_10093(face));
                    }
                }
                if ((blockState = world.method_8320(targetPos)).method_26214((class_1922)world, targetPos) == -1.0f || state.method_26220((class_1922)world, targetPos).method_1110() && !blockState.method_26220((class_1922)world, targetPos).method_1110()) {
                    if (targetPos.method_10264() == world.method_31607()) {
                        targetPos = targetPos.method_10084();
                    }
                    world.method_20290(2001, targetPos, class_2248.method_9507((class_2680)state));
                    class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)targetPos, null);
                    continue;
                }
                if (state.method_26204() instanceof class_3737 && state.method_28498((class_2769)class_2741.field_12508)) {
                    class_3610 FluidState = world.method_8316(targetPos);
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
                }
                world.method_22352(targetPos, true);
                if (AllBlocks.SHAFT.has(state)) {
                    state = ShaftBlock.pickCorrectShaftType(state, world, targetPos);
                }
                if (state.method_28498((class_2769)SlidingDoorBlock.VISIBLE)) {
                    state = (class_2680)((class_2680)state.method_11657((class_2769)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)SlidingDoorBlock.field_10945) == false))).method_11657((class_2769)SlidingDoorBlock.field_10940, (Comparable)Boolean.valueOf(false));
                }
                if (state.method_27852(class_2246.field_37571)) {
                    state = class_2246.field_37571.method_9564();
                }
                world.method_8652(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.method_10179();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != class_2470.field_11467;
                if (verticalRotation && (state.method_26204() instanceof PulleyBlock.RopeBlock || state.method_26204() instanceof PulleyBlock.MagnetBlock || state.method_26204() instanceof class_2323)) {
                    world.method_22352(targetPos, true);
                }
                class_2586 blockEntity = world.method_8321(targetPos);
                class_2487 tag = block.comp_1343();
                if (state.method_27852(class_2246.field_28108) || state.method_27852(class_2246.field_37571)) {
                    tag = null;
                }
                if (blockEntity != null) {
                    tag = NBTProcessors.process(blockEntity, tag, false);
                }
                if (blockEntity != null && tag != null) {
                    tag.method_10569("x", targetPos.method_10263());
                    tag.method_10569("y", targetPos.method_10264());
                    tag.method_10569("z", targetPos.method_10260());
                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.method_10551("Offset");
                        tag.method_10551("InitialOffset");
                    }
                    if (blockEntity instanceof IMultiBlockEntityContainer && tag.method_10545("LastKnownPos")) {
                        tag.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)class_2338.field_10980.method_10087(0x7FFFFFFE)));
                    }
                    blockEntity.method_11014(tag);
                    this.storage.addStorageToWorld(block, blockEntity);
                }
                transform.apply(blockEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            class_3499.class_3501 block = (class_3499.class_3501)object.next();
            if (!this.shouldUpdateAfterMovement(block)) continue;
            class_2338 targetPos = transform.apply(block.comp_1341());
            world.markAndNotifyBlock(targetPos, world.method_8500(targetPos), block.comp_1342(), block.comp_1342(), 67, 512);
        }
        for (class_238 box : this.superglue) {
            box = new class_238(transform.apply(new class_243(box.field_1323, box.field_1322, box.field_1321)), transform.apply(new class_243(box.field_1320, box.field_1325, box.field_1324)));
            if (world.field_9236) continue;
            world.method_8649((class_1297)new SuperGlueEntity(world, box));
        }
        this.storage.clear();
    }

    public void addPassengersToWorld(class_1937 world, StructureTransform transform, List<class_1297> seatedEntities) {
        for (class_1297 seatedEntity : seatedEntities) {
            Integer seatIndex;
            if (this.getSeatMapping().isEmpty() || (seatIndex = this.getSeatMapping().get(seatedEntity.method_5667())) == null) continue;
            class_2338 seatPos = this.getSeats().get(seatIndex);
            if (!(world.method_8320(seatPos = transform.apply(seatPos)).method_26204() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(class_1937 world) {
        this.disabledActors.clear();
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (class_3499.class_3501)pair.left, this);
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.left).comp_1342());
            if (behaviour != null) {
                behaviour.startMoving(context);
            }
            pair.setRight((Object)context);
            if (!(behaviour instanceof ContraptionControlsMovement)) continue;
            this.disableActorOnStart(context);
        }
        for (class_1799 stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
    }

    protected void disableActorOnStart(MovementContext context) {
        if (!ContraptionControlsMovement.isDisabledInitially(context)) {
            return;
        }
        class_1799 filter = ContraptionControlsMovement.getFilter(context);
        if (filter == null) {
            return;
        }
        if (this.isActorTypeDisabled(filter)) {
            return;
        }
        this.disabledActors.add(filter);
    }

    public boolean isActorTypeDisabled(class_1799 filter) {
        return this.disabledActors.stream().anyMatch(i -> ContraptionControlsMovement.isSameFilter(i, filter));
    }

    public void setActorsActive(class_1799 referenceStack, boolean enable) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            class_1799 behaviourStack;
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.left).comp_1342());
            if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)pair.right)) == null || !referenceStack.method_7960() && !ContraptionControlsMovement.isSameFilter(referenceStack, behaviourStack)) continue;
            boolean bl = ((MovementContext)pair.right).disabled = !enable;
            if (enable) continue;
            behaviour.onDisabledByControls((MovementContext)pair.right);
        }
    }

    public List<class_1799> getDisabledActors() {
        return this.disabledActors;
    }

    public void stop(class_1937 world) {
        this.forEachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = class_243.field_1353;
            ctx.relativeMotion = class_243.field_1353;
            ctx.rotation = v -> v;
        });
    }

    public void forEachActor(class_1937 world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.getLeft()).comp_1342());
            if (behaviour == null) continue;
            callBack.accept(behaviour, (MovementContext)pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(class_3499.class_3501 info) {
        if (class_7477.method_43989((class_2680)info.comp_1342()).isPresent()) {
            return false;
        }
        return !(info.comp_1342().method_26204() instanceof SlidingDoorBlock);
    }

    public void expandBoundsAroundAxis(class_2350.class_2351 axis) {
        Set<class_2338> blocks = this.getBlocks().keySet();
        int radius = (int)Math.ceil(Math.sqrt(Contraption.getRadius(blocks, axis)));
        int maxX = radius + 2;
        int maxY = radius + 2;
        int maxZ = radius + 2;
        int minX = -radius - 1;
        int minY = -radius - 1;
        int minZ = -radius - 1;
        if (axis == class_2350.class_2351.field_11048) {
            maxX = (int)this.bounds.field_1320;
            minX = (int)this.bounds.field_1323;
        } else if (axis == class_2350.class_2351.field_11052) {
            maxY = (int)this.bounds.field_1325;
            minY = (int)this.bounds.field_1322;
        } else if (axis == class_2350.class_2351.field_11051) {
            maxZ = (int)this.bounds.field_1324;
            minZ = (int)this.bounds.field_1321;
        }
        this.bounds = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public class_2338 getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public class_2338 getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<class_2338> getSeats() {
        return this.seats;
    }

    public Map<class_2338, class_3499.class_3501> getBlocks() {
        return this.blocks;
    }

    public List<MutablePair<class_3499.class_3501, MovementContext>> getActors() {
        return this.actors;
    }

    @Nullable
    public MutablePair<class_3499.class_3501, MovementContext> getActorAt(class_2338 localPos) {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            if (!localPos.equals((Object)((class_3499.class_3501)pair.left).comp_1341())) continue;
            return pair;
        }
        return null;
    }

    public Map<class_2338, MovingInteractionBehaviour> getInteractors() {
        return this.interactors;
    }

    @Environment(value=EnvType.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new EmptyLighter(this);
    }

    public void invalidateColliders() {
        this.simplifiedEntityColliders = Optional.empty();
        this.gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        this.getContraptionWorld();
        this.simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            class_265 combinedShape = class_259.method_1073();
            for (Map.Entry<class_2338, class_3499.class_3501> entry : this.blocks.entrySet()) {
                class_3499.class_3501 info = entry.getValue();
                class_2338 localPos = entry.getKey();
                class_265 collisionShape = info.comp_1342().method_26194((class_1922)this.world, localPos, class_3726.method_16194());
                if (collisionShape.method_1110()) continue;
                combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)collisionShape.method_1096((double)localPos.method_10263(), (double)localPos.method_10264(), (double)localPos.method_10260()), (class_247)class_247.field_1366);
            }
            return combinedShape.method_1097().method_1090();
        }).thenAccept(r -> {
            this.simplifiedEntityColliders = Optional.of(r);
            this.simplifiedEntityColliderProvider = null;
        });
    }

    public static float getRadius(Set<class_2338> blocks, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return Contraption.getMaxDistSqr(blocks, class_2382::method_10264, class_2382::method_10260);
            }
            case field_11052: {
                return Contraption.getMaxDistSqr(blocks, class_2382::method_10263, class_2382::method_10260);
            }
            case field_11051: {
                return Contraption.getMaxDistSqr(blocks, class_2382::method_10263, class_2382::method_10264);
            }
        }
        throw new IllegalStateException("Impossible axis");
    }

    public static float getMaxDistSqr(Set<class_2338> blocks, ICoordinate one, ICoordinate other) {
        float maxDistSq = -1.0f;
        for (class_2338 pos : blocks) {
            float b;
            float a = one.get(pos);
            float distSq = a * a + (b = other.get(pos)) * b;
            if (!(distSq > maxDistSq)) continue;
            maxDistSq = distSq;
        }
        return maxDistSq;
    }

    public ContraptionInvWrapper getSharedInventory() {
        return this.storage.getItems();
    }

    public ContraptionInvWrapper getSharedFuelInventory() {
        return this.storage.getFuelItems();
    }

    public CombinedTankWrapper getSharedFluidTanks() {
        return this.storage.getFluids();
    }

    public Collection<class_3499.class_3501> getRenderedBlocks() {
        return this.blocks.values();
    }

    public Collection<class_2586> getSpecialRenderedBEs() {
        return this.specialRenderedBlockEntities;
    }

    public boolean isHiddenInPortal(class_2338 localPos) {
        return false;
    }

    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        return this.simplifiedEntityColliders;
    }

    public void handleContraptionFluidPacket(class_2338 localPos, FluidStack containedFluid) {
        this.storage.updateContainedFluid(localPos, containedFluid);
    }

    public void tickStorage(AbstractContraptionEntity entity) {
        this.storage.entityTick(entity);
    }

    public boolean containsBlockBreakers() {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.getLeft()).comp_1342());
            if (!(behaviour instanceof BlockBreakingMovementBehaviour) && !(behaviour instanceof HarvesterMovementBehaviour)) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$readBlocksCompound$10(boolean usePalettedDeserialization, class_2814 finalPalette, class_7871 holderGetter, class_1937 world, class_2520 e) {
        class_2487 c = (class_2487)e;
        class_3499.class_3501 info = usePalettedDeserialization ? Contraption.readStructureBlockInfo(c, (class_2814<class_2680>)finalPalette) : Contraption.legacyReadStructureBlockInfo(c, (class_7871<class_2248>)holderGetter);
        this.blocks.put(info.comp_1341(), info);
        if (!world.field_9236) {
            return;
        }
        class_2487 tag = info.comp_1343();
        if (tag == null) {
            return;
        }
        tag.method_10569("x", info.comp_1341().method_10263());
        tag.method_10569("y", info.comp_1341().method_10264());
        tag.method_10569("z", info.comp_1341().method_10260());
        class_2586 be = class_2586.method_11005((class_2338)info.comp_1341(), (class_2680)info.comp_1342(), (class_2487)tag);
        if (be == null) {
            return;
        }
        be.method_31662(world);
        if (be instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)be;
            kbe.setSpeed(0.0f);
        }
        be.method_11010();
        MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour(info.comp_1342());
        if (movementBehaviour == null || !movementBehaviour.hasSpecialInstancedRendering()) {
            this.maybeInstancedBlockEntities.add(be);
        }
        if (movementBehaviour != null && !movementBehaviour.renderAsNormalBlockEntity()) {
            return;
        }
        this.presentBlockEntities.put(info.comp_1341(), be);
        this.specialRenderedBlockEntities.add(be);
    }

    public static class ContraptionInvWrapper
    extends CombinedStorage<ItemVariant, Storage<ItemVariant>> {
        protected final boolean isExternal;

        public ContraptionInvWrapper(boolean isExternal, Storage<ItemVariant> ... itemHandler) {
            super(List.of(itemHandler));
            this.isExternal = isExternal;
        }

        public ContraptionInvWrapper(Storage<ItemVariant> ... itemHandler) {
            this(false, itemHandler);
        }
    }
}

