/*
 * Decompiled with CFR 0.152.
 */
package net.guavy.gravestones.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.guavy.gravestones.Gravestones;
import net.guavy.gravestones.api.GravestonesApi;
import net.guavy.gravestones.block.entity.GravestoneBlockEntity;
import net.guavy.gravestones.config.GravestoneDropType;
import net.guavy.gravestones.config.GravestoneRetrievalType;
import net.guavy.gravestones.config.GravestonesConfig;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends class_2383
implements class_2343 {
    public GravestoneBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{class_2741.field_12481});
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (GravestonesConfig.getConfig().mainSettings.retrievalType == GravestoneRetrievalType.ON_STEP && entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            this.RetrieveGrave(playerEntity, world, pos);
        }
        super.method_9591(world, pos, state, entity);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (GravestonesConfig.getConfig().mainSettings.retrievalType == GravestoneRetrievalType.ON_USE) {
            this.RetrieveGrave(player, world, pos);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (GravestonesConfig.getConfig().mainSettings.retrievalType == GravestoneRetrievalType.ON_BREAK && this.RetrieveGrave(player, world, pos)) {
            return;
        }
        this.dropAllGrave(world, pos);
        super.method_9576(world, pos, state, player);
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ct) {
        return class_259.method_1081((double)0.1f, (double)0.0, (double)0.1f, (double)0.9f, (double)0.3f, (double)0.9f);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GravestoneBlockEntity(pos, state);
    }

    public void dropAllGrave(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof GravestoneBlockEntity)) {
            return;
        }
        GravestoneBlockEntity blockEntity = (GravestoneBlockEntity)be;
        blockEntity.method_5431();
        if (blockEntity.getItems() == null) {
            return;
        }
        class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.getItems());
        blockEntity.setItems((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[0]));
    }

    public boolean RetrieveGrave(class_1657 playerEntity, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return false;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof GravestoneBlockEntity)) {
            return false;
        }
        GravestoneBlockEntity blockEntity = (GravestoneBlockEntity)be;
        blockEntity.method_5431();
        if (blockEntity.getItems() == null) {
            return false;
        }
        if (blockEntity.getGraveOwner() == null) {
            return false;
        }
        if (!GravestonesConfig.getConfig().mainSettings.enableGraveLooting && !playerEntity.method_7334().getId().equals(blockEntity.getGraveOwner().getId())) {
            return false;
        }
        class_2371<class_1799> items = blockEntity.getItems();
        class_2371 retrievalInventory = class_2371.method_10211();
        retrievalInventory.addAll((Collection)playerEntity.method_31548().field_7547);
        retrievalInventory.addAll((Collection)playerEntity.method_31548().field_7548);
        retrievalInventory.addAll((Collection)playerEntity.method_31548().field_7544);
        for (GravestonesApi gravestonesApi : Gravestones.apiMods) {
            retrievalInventory.addAll(gravestonesApi.getInventory(playerEntity));
        }
        playerEntity.method_31548().method_5448();
        if (GravestonesConfig.getConfig().mainSettings.dropType == GravestoneDropType.PUT_IN_INVENTORY) {
            List armor = items.subList(36, 40);
            for (class_1799 itemStack : armor) {
                class_1304 equipmentSlot = class_1308.method_32326((class_1799)itemStack);
                playerEntity.method_5673(equipmentSlot, itemStack);
            }
            playerEntity.method_5673(class_1304.field_6171, (class_1799)items.get(40));
            List list = items.subList(0, 36);
            for (int i = 0; i < list.size(); ++i) {
                playerEntity.method_31548().method_7367(i, (class_1799)list.get(i));
            }
            class_2371 extraItems = class_2371.method_10211();
            List<Integer> openArmorSlots = this.getInventoryOpenSlots((class_2371<class_1799>)playerEntity.method_31548().field_7548);
            for (int i = 0; i < 4; ++i) {
                if (openArmorSlots.contains(i)) {
                    playerEntity.method_5673(class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)i), (class_1799)retrievalInventory.subList(36, 40).get(i));
                    continue;
                }
                extraItems.add((Object)((class_1799)retrievalInventory.subList(36, 40).get(i)));
            }
            if (playerEntity.method_31548().field_7544.get(0) == class_1799.field_8037) {
                playerEntity.method_5673(class_1304.field_6171, (class_1799)retrievalInventory.get(40));
            } else {
                extraItems.add((Object)((class_1799)retrievalInventory.get(40)));
            }
            extraItems.addAll((Collection)retrievalInventory.subList(0, 36));
            if (retrievalInventory.size() > 41) {
                extraItems.addAll((Collection)retrievalInventory.subList(41, retrievalInventory.size()));
            }
            List<Integer> openSlots = this.getInventoryOpenSlots((class_2371<class_1799>)playerEntity.method_31548().field_7547);
            for (int i = 0; i < openSlots.size(); ++i) {
                playerEntity.method_31548().method_7367(openSlots.get(i).intValue(), (class_1799)extraItems.get(i));
            }
            class_2371 dropItems = class_2371.method_10211();
            dropItems.addAll((Collection)extraItems.subList(openSlots.size(), extraItems.size()));
            int inventoryOffset = 41;
            for (GravestonesApi gravestonesApi : Gravestones.apiMods) {
                gravestonesApi.setInventory(items.subList(inventoryOffset, inventoryOffset + gravestonesApi.getInventorySize(playerEntity)), playerEntity);
                inventoryOffset += gravestonesApi.getInventorySize(playerEntity);
            }
            class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)dropItems);
        } else if (GravestonesConfig.getConfig().mainSettings.dropType == GravestoneDropType.DROP_ITEMS) {
            class_1264.method_17349((class_1937)world, (class_2338)pos, blockEntity.getItems());
        }
        playerEntity.method_7255((int)(GravestonesConfig.getConfig().mainSettings.xpPercentage * (double)blockEntity.getXp()));
        world.method_8650(pos, false);
        return true;
    }

    private List<Integer> getInventoryOpenSlots(class_2371<class_1799> inventory) {
        ArrayList<Integer> openSlots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.size(); ++i) {
            if (inventory.get(i) != class_1799.field_8037) continue;
            openSlots.add(i);
        }
        return openSlots;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof GravestoneBlockEntity) || !itemStack.method_7938()) {
            super.method_9567(world, pos, state, placer, itemStack);
            return;
        }
        GravestoneBlockEntity gravestoneBlockEntity = (GravestoneBlockEntity)blockEntity;
        gravestoneBlockEntity.setCustomName(itemStack.method_7911("display").method_10558("Name"));
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042());
    }
}

