/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves;

import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.common.protection.api.ProtectionProvider;
import eu.pb4.graves.CardboardWarning;
import eu.pb4.graves.GenericModInfo;
import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.GravesApi;
import eu.pb4.graves.compat.GomlCompat;
import eu.pb4.graves.compat.InventorioCompat;
import eu.pb4.graves.compat.SaveGearOnDeathCompat;
import eu.pb4.graves.compat.TrinketsCompat;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.other.Commands;
import eu.pb4.graves.other.GraveProtectionProvider;
import eu.pb4.graves.other.VanillaInventoryMask;
import eu.pb4.graves.registry.CointainerGraveBlockItem;
import eu.pb4.graves.registry.ContainerGraveBlock;
import eu.pb4.graves.registry.ContainerGraveBlockEntity;
import eu.pb4.graves.registry.GraveBlock;
import eu.pb4.graves.registry.GraveBlockEntity;
import eu.pb4.graves.registry.GraveCompassItem;
import eu.pb4.graves.registry.GraveGameRules;
import eu.pb4.graves.registry.IconItem;
import eu.pb4.graves.registry.SafeXPEntity;
import eu.pb4.graves.registry.TempBlock;
import eu.pb4.graves.registry.VisualGraveBlock;
import eu.pb4.graves.registry.VisualGraveBlockEntity;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1299;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GravesMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Universal Graves");
    public static final boolean DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final boolean IS_CLIENT = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    public static ModContainer CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("universal-graves").get();
    public static final List<Runnable> DO_ON_NEXT_TICK = new ArrayList<Runnable>();

    public void onInitialize() {
        CardboardWarning.checkAndAnnounce();
        FabricLoader loader = FabricLoader.getInstance();
        GenericModInfo.build(CONTAINER);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("universal_graves", "grave_compass"), (Object)GraveCompassItem.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("universal_graves", "visual_grave"), (Object)CointainerGraveBlockItem.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("universal_graves", "icon"), (Object)IconItem.INSTANCE);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("universal_graves", "grave"), (Object)((Object)GraveBlock.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("universal_graves", "visual_grave"), (Object)((Object)VisualGraveBlock.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("universal_graves", "container_grave"), (Object)((Object)ContainerGraveBlock.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("universal_graves", "temp_block"), (Object)((Object)TempBlock.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960("universal_graves", "xp"), SafeXPEntity.TYPE);
        PolymerEntityUtils.registerType((class_1299[])new class_1299[]{SafeXPEntity.TYPE});
        GraveBlockEntity.BLOCK_ENTITY_TYPE = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"universal_graves:grave", (Object)FabricBlockEntityTypeBuilder.create(GraveBlockEntity::new, (class_2248[])new class_2248[]{GraveBlock.INSTANCE}).build(null));
        VisualGraveBlockEntity.BLOCK_ENTITY_TYPE = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"universal_graves:visual_grave", (Object)FabricBlockEntityTypeBuilder.create(VisualGraveBlockEntity::new, (class_2248[])new class_2248[]{VisualGraveBlock.INSTANCE}).build(null));
        ContainerGraveBlockEntity.BLOCK_ENTITY_TYPE = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"universal_graves:container_grave", (Object)FabricBlockEntityTypeBuilder.create(ContainerGraveBlockEntity::new, (class_2248[])new class_2248[]{ContainerGraveBlock.INSTANCE}).build(null));
        Commands.register();
        PolymerBlockUtils.registerBlockEntity((class_2591[])new class_2591[]{GraveBlockEntity.BLOCK_ENTITY_TYPE, VisualGraveBlockEntity.BLOCK_ENTITY_TYPE, ContainerGraveBlockEntity.BLOCK_ENTITY_TYPE});
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(e -> {
            if (!Thread.currentThread().getName().contains("client")) {
                e.method_45421((class_1935)CointainerGraveBlockItem.INSTANCE);
            }
        });
        GraveTextures.initialize();
        new GraveGameRules();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            PolymerResourcePackUtils.addModAssets((String)"universal-graves");
        }
        CommonProtection.register((class_2960)new class_2960("universal_graves", "graves"), (ProtectionProvider)GraveProtectionProvider.INSTANCE);
        GravesApi.registerInventoryMask(new class_2960("vanilla"), VanillaInventoryMask.INSTANCE);
        if (loader.isModLoaded("goml")) {
            GomlCompat.register();
        }
        if (loader.isModLoaded("inventorio")) {
            InventorioCompat.register();
        }
        if (loader.isModLoaded("trinkets")) {
            TrinketsCompat.register();
        }
        if (loader.isModLoaded("sgod")) {
            SaveGearOnDeathCompat.register();
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigManager.loadConfig());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CardboardWarning.checkAndAnnounce());
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world == server.method_30002()) {
                GraveManager.INSTANCE = (GraveManager)world.method_17983().method_17924(nbt -> GraveManager.fromNbt(nbt, server), GraveManager::new, "universal-graves");
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(s -> {
            GraveManager.INSTANCE.tick(s);
            ArrayList<Runnable> copied = new ArrayList<Runnable>(DO_ON_NEXT_TICK);
            DO_ON_NEXT_TICK.clear();
            for (Runnable c : copied) {
                c.run();
            }
        });
    }
}

