/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.cache;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.util.HashSet;
import java.util.List;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.TextureAtlasSpriteWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.TintGetterOverrideFast;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.TintWithoutLevelOverrider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Logger;

public class ClientBlockStateCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final HashSet<BlockState> BLOCK_STATES_THAT_NEED_LEVEL = new HashSet();
    private static final HashSet<BlockState> BROKEN_BLOCK_STATES = new HashSet();
    public static final RandomSource random = RandomSource.m_216327_();
    public final BlockState blockState;
    public final LevelReader level;
    public final BlockPos pos;
    boolean isColorResolved = false;
    int baseColor = 0;
    boolean needShade = true;
    boolean needPostTinting = false;
    int tintIndex = 0;
    public static final int FLOWER_COLOR_SCALE = 5;
    private static final Direction[] DIRECTION_ORDER = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.DOWN};

    public ClientBlockStateCache(BlockState blockState, IClientLevelWrapper samplingLevel, DhBlockPos samplingPos) {
        this.blockState = blockState;
        this.level = (LevelReader)samplingLevel.getWrappedMcObject();
        this.pos = McObjectConverter.Convert(samplingPos);
        this.resolveColors();
    }

    private static int getWidth(TextureAtlasSprite texture) {
        return texture.m_245424_().m_246492_();
    }

    private static int getHeight(TextureAtlasSprite texture) {
        return texture.m_245424_().m_245330_();
    }

    private static int calculateColorFromTexture(TextureAtlasSprite texture, ColorMode colorMode) {
        int tempColor;
        int count = 0;
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int u = 0; u < ClientBlockStateCache.getWidth(texture); ++u) {
            for (int v = 0; v < ClientBlockStateCache.getHeight(texture); ++v) {
                tempColor = TextureAtlasSpriteWrapper.getPixelRGBA(texture, 0, u, v);
                double r = (double)(tempColor & 0xFF) / 255.0;
                double g = (double)((tempColor & 0xFF00) >>> 8) / 255.0;
                double b = (double)((tempColor & 0xFF0000) >>> 16) / 255.0;
                double a = (double)((tempColor & 0xFF000000) >>> 24) / 255.0;
                int scale = 1;
                if (colorMode == ColorMode.Leaves) {
                    r *= a;
                    g *= a;
                    b *= a;
                    a = 1.0;
                } else {
                    if (a == 0.0) continue;
                    if (colorMode == ColorMode.Flower && (g + 0.1 < b || g + 0.1 < r)) {
                        scale = 5;
                    }
                }
                count += scale;
                alpha += a * a * (double)scale;
                red += r * r * (double)scale;
                green += g * g * (double)scale;
                blue += b * b * (double)scale;
            }
        }
        tempColor = count == 0 ? ColorUtil.rgbToInt(0, 255, 255, 255) : ColorUtil.rgbToInt((int)(Math.sqrt(alpha / (double)count) * 255.0), (int)(Math.sqrt(red / (double)count) * 255.0), (int)(Math.sqrt(green / (double)count) * 255.0), (int)(Math.sqrt(blue / (double)count) * 255.0));
        return tempColor;
    }

    private void resolveColors() {
        if (this.isColorResolved) {
            return;
        }
        if (this.blockState.m_60819_().m_76178_()) {
            List quads = null;
            for (Direction direction : DIRECTION_ORDER) {
                quads = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(this.blockState).m_213637_(this.blockState, direction, random);
                if (quads != null && !quads.isEmpty() && (!(this.blockState.m_60734_() instanceof RotatedPillarBlock) || direction != Direction.UP)) break;
            }
            if (quads == null || quads.isEmpty()) {
                quads = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(this.blockState).m_213637_(this.blockState, null, random);
            }
            if (quads != null && !quads.isEmpty()) {
                this.needPostTinting = ((BakedQuad)quads.get(0)).m_111304_();
                this.needShade = ((BakedQuad)quads.get(0)).m_111307_();
                this.tintIndex = ((BakedQuad)quads.get(0)).m_111305_();
                this.baseColor = ClientBlockStateCache.calculateColorFromTexture(((BakedQuad)quads.get(0)).m_173410_(), ColorMode.getColorMode(this.blockState.m_60734_()));
            } else {
                this.needPostTinting = false;
                this.needShade = false;
                this.tintIndex = 0;
                this.baseColor = ClientBlockStateCache.calculateColorFromTexture(Minecraft.m_91087_().m_91304_().m_119430_().m_110882_(this.blockState), ColorMode.getColorMode(this.blockState.m_60734_()));
            }
        } else {
            this.needPostTinting = true;
            this.needShade = false;
            this.tintIndex = 0;
            this.baseColor = ClientBlockStateCache.calculateColorFromTexture(Minecraft.m_91087_().m_91304_().m_119430_().m_110882_(this.blockState), ColorMode.getColorMode(this.blockState.m_60734_()));
        }
        this.isColorResolved = true;
    }

    public int getAndResolveFaceColor(BiomeWrapper biome, DhBlockPos pos) {
        int tintColor;
        block9: {
            if (!this.needPostTinting) {
                return this.baseColor;
            }
            if (BROKEN_BLOCK_STATES.contains(this.blockState)) {
                return this.baseColor;
            }
            tintColor = -1;
            try {
                if (!BLOCK_STATES_THAT_NEED_LEVEL.contains(this.blockState)) {
                    try {
                        tintColor = Minecraft.m_91087_().m_91298_().m_92577_(this.blockState, (BlockAndTintGetter)new TintWithoutLevelOverrider(biome), McObjectConverter.Convert(pos), this.tintIndex);
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.debug("Unable to use [" + TintWithoutLevelOverrider.class.getSimpleName() + "] to get the block tint for block: [" + this.blockState + "] and biome: [" + biome + "] at pos: " + pos + ". Error: [" + e.getMessage() + "]. Attempting to use backup method...", (Throwable)e);
                        BLOCK_STATES_THAT_NEED_LEVEL.add(this.blockState);
                    }
                }
                if (BLOCK_STATES_THAT_NEED_LEVEL.contains(this.blockState)) {
                    tintColor = Minecraft.m_91087_().m_91298_().m_92577_(this.blockState, (BlockAndTintGetter)new TintGetterOverrideFast(this.level), McObjectConverter.Convert(pos), this.tintIndex);
                }
            }
            catch (Exception e) {
                if (BROKEN_BLOCK_STATES.contains(this.blockState)) break block9;
                LOGGER.warn("Failed to get block color for block: [" + this.blockState + "] and biome: [" + biome + "] at pos: " + pos + ". Error: [" + e.getMessage() + "]. Note: future errors for this block/biome will be ignored.", (Throwable)e);
                BROKEN_BLOCK_STATES.add(this.blockState);
            }
        }
        if (tintColor != -1) {
            return ColorUtil.multiplyARGBwithRGB(this.baseColor, tintColor);
        }
        return this.baseColor;
    }

    static enum ColorMode {
        Default,
        Flower,
        Leaves;


        static ColorMode getColorMode(Block b) {
            if (b instanceof LeavesBlock) {
                return Leaves;
            }
            if (b instanceof FlowerBlock) {
                return Flower;
            }
            return Default;
        }
    }
}

