/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3d;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.WrapperFactory;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.minecraft.class_761;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final class_310 MC = class_310.method_1551();
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    private static final IOptifineAccessor OPTIFINE_ACCESSOR = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public HashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new HashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean usingBackupGetVanillaRenderedChunks = false;

    @Override
    public Vec3f getLookAtVector() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        Vector3f cameraDir = camera.method_19335();
        return new Vec3f(cameraDir.x(), cameraDir.y(), cameraDir.z());
    }

    @Override
    public DhBlockPos getCameraBlockPosition() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        class_2338 blockPos = camera.method_19328();
        return new DhBlockPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        return MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_5919) != null || MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_38092) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        class_243 projectedView = camera.method_19326();
        return new Vec3d(projectedView.field_1352, projectedView.field_1351, projectedView.field_1350);
    }

    @Override
    public Mat4f getDefaultProjectionMatrix(float partialTicks) {
        return McObjectConverter.Convert(MinecraftRenderWrapper.MC.field_1773.method_22973(MinecraftRenderWrapper.MC.field_1773.method_3196(MinecraftRenderWrapper.MC.field_1773.method_19418(), partialTicks, true)));
    }

    @Override
    public double getGamma() {
        return (Double)MinecraftRenderWrapper.MC.field_1690.method_42473().method_41753();
    }

    @Override
    public Color getFogColor(float partialTicks) {
        class_758.method_3210((class_4184)MinecraftRenderWrapper.MC.field_1773.method_19418(), (float)partialTicks, (class_638)MinecraftRenderWrapper.MC.field_1687, (int)1, (float)MinecraftRenderWrapper.MC.field_1773.method_3195(partialTicks));
        float[] colorValues = RenderSystem.getShaderFogColor();
        return new Color(Math.max(0.0f, Math.min(colorValues[0], 1.0f)), Math.max(0.0f, Math.min(colorValues[1], 1.0f)), Math.max(0.0f, Math.min(colorValues[2], 1.0f)), Math.max(0.0f, Math.min(colorValues[3], 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.field_1687.method_8597().comp_642()) {
            class_243 colorValues = MinecraftRenderWrapper.MC.field_1687.method_23777(MinecraftRenderWrapper.MC.field_1773.method_19418().method_19326(), MC.method_1488());
            return new Color((float)colorValues.field_1352, (float)colorValues.field_1351, (float)colorValues.field_1350);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.field_1773.method_3196(MinecraftRenderWrapper.MC.field_1773.method_19418(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.field_1690.method_38521();
    }

    @Override
    public int getScreenWidth() {
        int width = MC.method_22683().method_4489();
        if (OPTIFINE_ACCESSOR != null) {
            width = (int)((double)width * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return width;
    }

    @Override
    public int getScreenHeight() {
        int height = MC.method_22683().method_4506();
        if (OPTIFINE_ACCESSOR != null) {
            height = (int)((double)height * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return height;
    }

    private class_276 getRenderTarget() {
        return MC.method_1522();
    }

    @Override
    public int getTargetFrameBuffer() {
        int frameBufferOverrideId = DhApiRenderProxy.INSTANCE.targetFrameBufferOverride;
        if (frameBufferOverrideId != -1) {
            return frameBufferOverrideId;
        }
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return this.getRenderTarget().field_1476;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        return this.getRenderTarget().method_30278();
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().field_1480;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().field_1477;
    }

    @Override
    public HashSet<DhChunkPos> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorInjector.INSTANCE.get(ISodiumAccessor.class);
        if (sodium != null) {
            return sodium.getNormalRenderedChunks();
        }
        IOptifineAccessor optifine = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
        if (optifine != null) {
            HashSet<DhChunkPos> pos = optifine.getNormalRenderedChunks();
            if (pos == null) {
                pos = this.getMaximumRenderedChunks();
            }
            return pos;
        }
        if (!this.usingBackupGetVanillaRenderedChunks) {
            try {
                class_761 levelRenderer = MinecraftRenderWrapper.MC.field_1769;
                LinkedHashSet chunks = ((class_761.class_6600)levelRenderer.field_34817.get()).field_34819;
                return chunks.stream().map(chunk -> {
                    class_238 chunkBoundingBox = chunk.field_4124.method_40051();
                    return new DhChunkPos(Math.floorDiv((int)chunkBoundingBox.field_1323, 16), Math.floorDiv((int)chunkBoundingBox.field_1321, 16));
                }).collect(Collectors.toCollection(HashSet::new));
            }
            catch (LinkageError e) {
                try {
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7e\u00a7l\u00a7uWARNING: Distant Horizons: getVanillaRenderedChunks method failed. Using Backup Method.");
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7eOverdraw prevention will be worse than normal.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.error("getVanillaRenderedChunks Error: ", (Throwable)e);
                this.usingBackupGetVanillaRenderedChunks = true;
            }
        }
        return this.getMaximumRenderedChunks();
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.field_1773.method_19418().method_19334() != class_5636.field_27888 || isBlind;
    }

    public void updateLightmap(class_1011 lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        if (!this.lightmapByDimensionType.containsKey(dimensionType)) {
            this.lightmapByDimensionType.put(dimensionType, new LightMapWrapper());
        }
        this.lightmapByDimensionType.get(dimensionType).uploadLightmap(lightPixels);
    }
}

