/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge.mixins.client;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.DependencySetupDoneCheck;
import net.minecraft.client.renderer.GameRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    private static final Logger LOGGER = LogManager.getLogger((String)MixinGameRenderer.class.getSimpleName());

    @Inject(method={"reloadShaders", "preloadUiShader"}, at={@At(value="TAIL")})
    public void onStartupShaders(CallbackInfo ci) {
        LOGGER.info("Starting up renderer (forge)");
        if (!DependencySetupDoneCheck.isDone) {
            LOGGER.warn("Dependency setup is not done yet, skipping renderer this startup event!");
            return;
        }
        ClientApi.INSTANCE.rendererStartupEvent();
    }

    @Inject(method={"shutdownShaders"}, at={@At(value="HEAD")})
    public void onShutdownShaders(CallbackInfo ci) {
        LOGGER.info("Shutting down renderer (forge)");
        if (!DependencySetupDoneCheck.isDone) {
            LOGGER.warn("Dependency setup is not done yet, skipping renderer this shutdown event!");
            return;
        }
        ClientApi.INSTANCE.rendererShutdownEvent();
    }
}

