/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.structure.ClientOnlySaveStructure;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.EventLoop;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DhClientWorld
extends AbstractDhWorld
implements IDhClientWorld {
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private final ConcurrentHashMap<IClientLevelWrapper, DhClientLevel> levels;
    public final ClientOnlySaveStructure saveStructure;
    public ExecutorService dhTickerThread = ThreadUtil.makeSingleThreadPool("Client World Ticker Thread");
    public EventLoop eventLoop = new EventLoop(this.dhTickerThread, this::_clientTick);

    public DhClientWorld() {
        super(EWorldEnvironment.Client_Only);
        this.saveStructure = new ClientOnlySaveStructure();
        this.levels = new ConcurrentHashMap();
        LOGGER.info("Started DhWorld of type " + (Object)((Object)this.environment));
    }

    private void registerNetworkHandlers() {
    }

    @Override
    public DhClientLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return null;
        }
        return this.levels.computeIfAbsent((IClientLevelWrapper)wrapper, clientLevelWrapper -> {
            File file = this.saveStructure.getLevelFolder(wrapper);
            if (file == null) {
                return null;
            }
            return new DhClientLevel(this.saveStructure, (IClientLevelWrapper)clientLevelWrapper);
        });
    }

    @Override
    public DhClientLevel getLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return null;
        }
        return this.levels.get(wrapper);
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return this.levels.values();
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return;
        }
        if (this.levels.containsKey(wrapper)) {
            LOGGER.info("Unloading level " + this.levels.get(wrapper));
            wrapper.onUnload();
            this.levels.remove(wrapper).close();
        }
    }

    private void _clientTick() {
        this.levels.values().forEach(DhClientLevel::clientTick);
    }

    @Override
    public void clientTick() {
        this.eventLoop.tick();
    }

    @Override
    public void doWorldGen() {
    }

    @Override
    public CompletableFuture<Void> saveAndFlush() {
        return CompletableFuture.allOf((CompletableFuture[])this.levels.values().stream().map(DhClientLevel::saveAsync).toArray(CompletableFuture[]::new));
    }

    @Override
    public void close() {
        this.saveAndFlush();
        for (DhClientLevel dhClientLevel : this.levels.values()) {
            LOGGER.info("Unloading level " + dhClientLevel.getLevelWrapper().getDimensionType().getDimensionName());
            IClientLevelWrapper clientLevelWrapper = dhClientLevel.getClientLevelWrapper();
            if (clientLevelWrapper != null) {
                clientLevelWrapper.onUnload();
            }
            dhClientLevel.close();
        }
        this.levels.clear();
        this.eventLoop.close();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment));
    }
}

